/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.timer;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.api.job.Job;
import org.jbpm.api.listener.EventListener;
import org.jbpm.api.listener.EventListenerExecution;
import org.jbpm.test.JbpmTestCase;

public class TimerTest
extends JbpmTestCase {
    private static final String TEST_PROCESS_CUSTOM = "<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <custom continue='async' name='a' class='" + MyCustomWait.class.getName() + "'>" + "    <transition to='b' />" + "    <transition name='timeout' to='escalate'>" + "      <event-listener class='" + MyCustomWait.class.getName() + "'/>" + "      <timer duedate='2 minutes' />" + "    </transition>" + "  </custom>" + "  <state name='b' />" + "  <end name='escalate' />" + "</process>";

    public void testTimerTimeout() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='2 minutes' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerInFuture() {
        this.deployJpdlXmlString("<process name='theProcess'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='10 years' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("theProcess");
        Calendar now = Calendar.getInstance();
        int currentYear = now.get(1);
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        TimerTest.assertEquals((int)(currentYear + 10), (int)jobDate.get(1));
    }

    public void testTimerELDate() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var}' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Date> proc_vars = new HashMap<String, Date>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 6);
        proc_vars.put("proc_var", cal.getTime());
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        TimerTest.assertEquals((int)cal.get(5), (int)jobDate.get(5));
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELCalendar() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var}' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 6);
        proc_vars.put("proc_var", cal);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        TimerTest.assertEquals((int)cal.get(5), (int)jobDate.get(5));
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELString() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var}' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, String> proc_vars = new HashMap<String, String>();
        proc_vars.put("proc_var", "2 minutes");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Date jobDate = job.getDuedate();
        TimerTest.assertTrue((String)"should less than 2 minutes", (jobDate.getTime() - new Date().getTime() <= 120000L ? 1 : 0) != 0);
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELCalendarAdd() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var} + 5 days' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 6);
        proc_vars.put("proc_var", cal);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        cal.add(5, 5);
        TimerTest.assertEquals((int)cal.get(5), (int)jobDate.get(5));
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELCalendarSubtract() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var} - 5 days' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 6);
        proc_vars.put("proc_var", cal);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        cal.add(5, -5);
        TimerTest.assertEquals((int)cal.get(5), (int)jobDate.get(5));
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELCalendarAddBusiness() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var} + 5 business days' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 1, 12, 12, 0, 0);
        proc_vars.put("proc_var", cal);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        Calendar jobDate = Calendar.getInstance();
        jobDate.setTime(job.getDuedate());
        TimerTest.assertEquals((int)19, (int)jobDate.get(5));
        this.managementService.executeJob(job.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELFail() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var}' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Long> proc_vars = new HashMap<String, Long>();
        proc_vars.put("proc_var", new Long(0L));
        try {
            this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
            TimerTest.fail((String)"Should not happen, exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTimerELSubtractBusinessFail() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var} - 6 business days' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 1, 12, 12, 0, 0);
        proc_vars.put("proc_var", cal);
        try {
            this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
            TimerTest.fail((String)"Should not happen, exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTimerELSubtractPastFail() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='b' />    <transition name='timeout' to='escalate'>      <timer duedate='#{proc_var} - 3 days' />    </transition>  </state>  <state name='b' />  <end name='escalate' /></process>");
        HashMap<String, Calendar> proc_vars = new HashMap<String, Calendar>();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 2);
        proc_vars.put("proc_var", cal);
        try {
            this.executionService.startProcessInstanceByKey("ICL", proc_vars, "82436");
            TimerTest.fail((String)"Should not happen, exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTimerTimeoutCustom() {
        this.deployJpdlXmlString(TEST_PROCESS_CUSTOM);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL");
        TimerTest.assertEquals((String)"inactive-scope", (String)processInstance.getState());
        this.assertNotActivityActive(processInstance.getId(), "a");
        Job async = this.managementService.createJobQuery().messages().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(async.getId());
        this.assertActivityActive(processInstance.getId(), "a");
        try {
            this.executionService.signalExecutionById(processInstance.getId());
            TimerTest.fail((String)"Should not happen, exception expected");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
        this.assertProcessInstanceActive(processInstance);
        this.executionService.signalExecutionById(processInstance.getExecution("a").getId());
        this.assertActivityActive(processInstance.getId(), "b");
    }

    public void testTimerSignalCustom() {
        this.deployJpdlXmlString(TEST_PROCESS_CUSTOM);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL");
        Job async = this.managementService.createJobQuery().messages().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(async.getId());
        int beforeTimer = MyCustomWait.nrOfTimesCalled;
        Job timer = this.managementService.createJobQuery().timers().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(timer.getId());
        int afterTimer = MyCustomWait.nrOfTimesCalled;
        TimerTest.assertEquals((int)(beforeTimer + 1), (int)afterTimer);
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerRepeat() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <on event='timeout'>     <timer duedate='20 minutes' repeat='10 seconds' />     <event-listener class='" + MyCustomWait.class.getName() + "' />" + "   </on>" + "    <transition to='b' />" + "  </state>" + "  <state name='b' >" + "    <transition to='escalate' />" + "  </state>" + "  <end name='escalate' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        String processInstanceId = processInstance.findActiveExecutionIn("a").getId();
        processInstance = this.executionService.signalExecutionById(processInstanceId);
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    public void testTimerELRepeat() {
        this.deployJpdlXmlString("<process name='Insurance claim' key='ICL'>  <start>    <transition to='a' />  </start>  <state name='a'>    <on event='timeout'>     <timer duedate='20 minutes' repeat='#{repeat}' />     <event-listener class='" + MyCustomWait.class.getName() + "' />" + "   </on>" + "    <transition to='b' />" + "  </state>" + "  <state name='b' >" + "    <transition to='escalate' />" + "  </state>" + "  <end name='escalate' />" + "</process>");
        Map<String, String> variables = Collections.singletonMap("repeat", "20 seconds");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ICL", variables, "82436");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        String processInstanceId = processInstance.findActiveExecutionIn("a").getId();
        processInstance = this.executionService.signalExecutionById(processInstanceId);
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        this.assertProcessInstanceEnded(processInstance);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyCustomWait
    implements ExternalActivityBehaviour,
    EventListener {
        private static final long serialVersionUID = 1L;
        static int nrOfTimesCalled;

        public void execute(ActivityExecution execution) throws Exception {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            execution.take(signalName);
        }

        public void notify(EventListenerExecution execution) throws Exception {
            ++nrOfTimesCalled;
        }
    }
}

