/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jbpm.test.JbpmTestCase;

public class BasicVariablesTest
extends JbpmTestCase {
    public void testStartProcessInstanceWithoutVariables() {
        this.deployJpdlXmlString("<process name='var'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        BasicVariablesTest.assertNotNull((Object)variableNames);
        BasicVariablesTest.assertEquals((int)0, (int)variableNames.size());
    }

    public void testStartProcessInstanceWithThreeVariables() {
        this.deployJpdlXmlString("<process name='var'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        Map<String, Object> variables = new HashMap<String, Object>();
        variables.put("customer", "John Doe");
        variables.put("type", "Accident");
        variables.put("amount", new Float(763.74));
        HashSet expectedVariableNames = new HashSet(variables.keySet());
        HashMap expectedVariables = new HashMap(variables);
        this.executionService.startProcessInstanceByKey("var", variables, "one");
        Set variableNames = this.executionService.getVariableNames("var.one");
        BasicVariablesTest.assertNotNull((Object)variableNames);
        BasicVariablesTest.assertEquals(expectedVariableNames, (Object)variableNames);
        variables = this.executionService.getVariables("var.one", variableNames);
        BasicVariablesTest.assertEquals(expectedVariables, variables);
    }

    public void testSetAndUpdateVariable() {
        this.deployJpdlXmlString("<process name='var'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        this.executionService.setVariable("var.one", "msg", (Object)"hello");
        BasicVariablesTest.assertEquals((Object)"hello", (Object)this.executionService.getVariable("var.one", "msg"));
        this.executionService.setVariable("var.one", "msg", (Object)"world");
        BasicVariablesTest.assertEquals((Object)"world", (Object)this.executionService.getVariable("var.one", "msg"));
    }

    public void testUpdateVariableToDifferentType() {
        this.deployJpdlXmlString("<process name='var'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'/></process>");
        this.executionService.startProcessInstanceByKey("var", "one");
        this.executionService.setVariable("var.one", "msg", (Object)"hello");
        BasicVariablesTest.assertEquals((Object)"hello", (Object)this.executionService.getVariable("var.one", "msg"));
        this.executionService.setVariable("var.one", "msg", (Object)new Integer(5));
        BasicVariablesTest.assertEquals((Object)new Integer(5), (Object)this.executionService.getVariable("var.one", "msg"));
    }
}

