/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import org.jbpm.api.Execution;
import org.jbpm.test.JbpmTestCase;

public class JoinTest
extends JbpmTestCase {
    public void testMultiplicityLessThanIncomingTransitions() {
        this.deployJpdlXmlString("<process name='multiplicityProcess'>  <start>    <transition to='theFork' />  </start>  <fork name='theFork'>    <transition to='stateOne' />    <transition to='stateTwo' />    <transition to='stateThree' />  </fork>  <state name='stateOne'>    <transition to='theJoin' />  </state>   <state name='stateTwo'>    <transition to='theJoin' />  </state>   <state name='stateThree'>    <transition to='theJoin' />  </state>   <join name='theJoin' multiplicity='2'>    <transition to='end' />  </join>  <end name='end' /></process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("multiplicityProcess").getId();
        this.assertActivitiesActive(processInstanceId, new String[]{"stateOne", "stateTwo", "stateThree"});
        Execution executionInStateOne = this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("stateOne");
        this.executionService.signalExecutionById(executionInStateOne.getId());
        this.assertProcessInstanceActive(processInstanceId);
        Execution executionInStateTwo = this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("stateTwo");
        this.executionService.signalExecutionById(executionInStateTwo.getId());
        this.assertProcessInstanceEnded(processInstanceId);
    }

    public void testNoMultiplicity() {
        this.deployJpdlXmlString("<process name='multiplicityProcess'>  <start>    <transition to='theFork' />  </start>  <fork name='theFork'>    <transition to='stateOne' />    <transition to='stateTwo' />    <transition to='stateThree' />  </fork>  <state name='stateOne'>    <transition to='theJoin' />  </state>   <state name='stateTwo'>    <transition to='theJoin' />  </state>   <state name='stateThree'>    <transition to='theJoin' />  </state>   <join name='theJoin'>    <transition to='end' />  </join>  <end name='end' /></process>");
        String processInstanceId = this.executionService.startProcessInstanceByKey("multiplicityProcess").getId();
        this.assertActivitiesActive(processInstanceId, new String[]{"stateOne", "stateTwo", "stateThree"});
        this.executionService.signalExecutionById(this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("stateOne").getId());
        this.assertProcessInstanceActive(processInstanceId);
        this.executionService.signalExecutionById(this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("stateTwo").getId());
        this.assertProcessInstanceActive(processInstanceId);
        this.executionService.signalExecutionById(this.executionService.findExecutionById(processInstanceId).findActiveExecutionIn("stateThree").getId());
        this.assertProcessInstanceEnded(processInstanceId);
    }
}

