/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activities;

import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class StateTest
extends JbpmTestCase {
    public void testWaitStatesSequence() {
        this.deployJpdlXmlString("<process name='ThreeStates'>  <start name='a'>    <transition to='b' />  </start>  <state name='b'>    <transition to='c' />  </state>  <state name='c'>    <transition to='d' />  </state>  <end name='d' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceById("ThreeStates-1");
        StateTest.assertTrue((boolean)processInstance.isActive("b"));
        String executionId = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(executionId);
        StateTest.assertTrue((boolean)processInstance.isActive("c"));
        processInstance = this.executionService.signalExecutionById(executionId);
        StateTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testExternalDecision() {
        this.deployJpdlXmlString("<process name='p'>  <start>    <transition to='ed' />  </start>  <state name='ed'>    <transition name='left'   to='b' />    <transition name='middle' to='c' />    <transition name='right'  to='d' />  </state>  <state name='b' />  <state name='c' />  <state name='d' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("p", "one");
        StateTest.assertTrue((boolean)processInstance.isActive("ed"));
        processInstance = this.executionService.signalExecutionById("p.one", "left");
        StateTest.assertTrue((boolean)processInstance.isActive("b"));
        this.executionService.startProcessInstanceById("p-1", "two");
        processInstance = this.executionService.signalExecutionById("p.two", "middle");
        StateTest.assertTrue((boolean)processInstance.isActive("c"));
        this.executionService.startProcessInstanceById("p-1", "three");
        processInstance = this.executionService.signalExecutionById("p.three", "right");
        StateTest.assertTrue((boolean)processInstance.isActive("d"));
    }

    public void testDefaultSignalWithNamedTransitions() {
        this.deployJpdlXmlString("<process name='p'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition name='left'   to='b' />    <transition name='middle' to='c' />    <transition name='right'  to='d' />  </state>  <state name='b' />  <state name='c' />  <state name='d' /></process>");
        this.executionService.startProcessInstanceByKey("p", "one");
        try {
            this.executionService.signalExecutionById("p.one", "left");
        }
        catch (JbpmException e) {
            this.assertTextPresent("no matching transition or event for default signal in state(a)", e.getMessage());
        }
    }

    public void testNamedSignalWithoutMatchingTransition() {
        this.deployJpdlXmlString("<process name='p'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition name='left'   to='b' />    <transition name='middle' to='c' />    <transition name='right'  to='d' />  </state>  <state name='b' />  <state name='c' />  <state name='d' /></process>");
        this.executionService.startProcessInstanceByKey("p", "one");
        ProcessInstance processInstance = this.executionService.signalExecutionById("p.one", "up");
        StateTest.assertTrue((boolean)processInstance.isActive("a"));
    }

    public void testDefaultSignalWithoutTransitions() {
        this.deployJpdlXmlString("<process name='p'>  <start>    <transition to='a' />  </start>  <state name='a' /></process>");
        this.executionService.startProcessInstanceByKey("p", "one");
        ProcessInstance processInstance = this.executionService.signalExecutionById("p.one");
        StateTest.assertTrue((boolean)processInstance.isActive("a"));
    }

    public void testSelfTransition() {
        this.deployJpdlXmlString("<process name='selfTransition'>  <start>    <transition to='wait' />  </start>  <state name='wait' >    <transition to='wait' />  </state></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("selfTransition");
        StateTest.assertTrue((boolean)processInstance.isActive("wait"));
        this.executionService.signalExecutionById(processInstance.getId());
        StateTest.assertTrue((boolean)processInstance.isActive("wait"));
    }

    public void testLoopBackToSignalledState() {
        this.deployJpdlXmlString("<process name='loopBackToState'>  <start>    <transition to='wait' />  </start>  <state name='wait' >    <transition to='go further' />  </state>  <custom name='go further' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='go even further' />  </custom>  <custom name='go even further' class='org.jbpm.test.activities.PassThroughActivity' >    <transition to='wait' />  </custom>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("loopBackToState");
        StateTest.assertTrue((boolean)processInstance.isActive("wait"));
        this.executionService.signalExecutionById(processInstance.getId());
        StateTest.assertTrue((boolean)processInstance.isActive("wait"));
    }
}

