/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.test.JbpmTestCase;

public class CustomConfigurationsTest
extends JbpmTestCase {
    public void testCustomAutomaticClass() {
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + MyCustomAutomatic.class.getName() + "'>" + "    <transition to='wait' />" + "  </custom>" + "  <state name='wait'/>" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomClass");
        CustomConfigurationsTest.assertTrue((boolean)processInstance.findActiveActivityNames().contains("wait"));
    }

    public void testCustomWaitClass() {
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + MyCustomWait.class.getName() + "'>" + "    <transition name='1' to='the 1st way' />" + "    <transition name='2' to='the 2nd way' />" + "    <transition name='3' to='the 3rd way' />" + "  </custom>" + "  <state name='the 1st way' />" + "  <state name='the 2nd way' />" + "  <state name='the 3rd way' />" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomClass");
        Set findActiveActivityNames = processInstance.findActiveActivityNames();
        CustomConfigurationsTest.assertTrue((boolean)findActiveActivityNames.contains("c"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        findActiveActivityNames = processInstance.findActiveActivityNames();
        CustomConfigurationsTest.assertTrue((boolean)findActiveActivityNames.contains("the 3rd way"));
    }

    public void testCustomAutomaticClassWithInjections() {
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + MyCustomAutomaticWithFieldAndProperty.class.getName() + "'>" + "    <field name='text'><string value='hi' /></field>" + "    <property name='numberProperty'><long value='5' /></property>" + "    <field name='basicInt'><int value='6' /></field>" + "    <field name='objectInt'><int value='7' /></field>" + "    <field name='basicLong'><long value='99999999999' /></field>" + "    <field name='basicFloat'><float value='99.99' /></field>" + "    <field name='objectFloat'><float value='88.88' /></field>" + "    <field name='basicDouble'><double value='9999999999.99' /></field>" + "    <field name='objectDouble'><double value='8888888888.88' /></field>" + "    <field name='basicBooleanTrue'><true /></field>" + "    <field name='basicBooleanFalse'><false /></field>" + "    <field name='objectBooleanTrue'><true /></field>" + "    <field name='objectBooleanFalse'><false /></field>" + "    <transition to='wait' />" + "  </custom>" + "  <state name='wait'/>" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomClass");
        CustomConfigurationsTest.assertTrue((boolean)processInstance.findActiveActivityNames().contains("wait"));
        CustomConfigurationsTest.assertEquals((Object)"hi", (Object)this.executionService.getVariable(processInstance.getId(), "text"));
        CustomConfigurationsTest.assertEquals((Object)new Long(5L), (Object)this.executionService.getVariable(processInstance.getId(), "number"));
        CustomConfigurationsTest.assertEquals((Object)new Integer("6"), (Object)this.executionService.getVariable(processInstance.getId(), "basicInt"));
        CustomConfigurationsTest.assertEquals((Object)new Integer("7"), (Object)this.executionService.getVariable(processInstance.getId(), "objectInt"));
        CustomConfigurationsTest.assertEquals((Object)99999999999L, (Object)this.executionService.getVariable(processInstance.getId(), "basicLong"));
        CustomConfigurationsTest.assertEquals((Object)new Float("99.99"), (Object)this.executionService.getVariable(processInstance.getId(), "basicFloat"));
        CustomConfigurationsTest.assertEquals((Object)new Float("88.88"), (Object)this.executionService.getVariable(processInstance.getId(), "objectFloat"));
        CustomConfigurationsTest.assertEquals((Object)new Double("9999999999.99"), (Object)this.executionService.getVariable(processInstance.getId(), "basicDouble"));
        CustomConfigurationsTest.assertEquals((Object)new Double("8888888888.88"), (Object)this.executionService.getVariable(processInstance.getId(), "objectDouble"));
        CustomConfigurationsTest.assertEquals((Object)Boolean.TRUE, (Object)this.executionService.getVariable(processInstance.getId(), "basicBooleanTrue"));
        CustomConfigurationsTest.assertEquals((Object)Boolean.FALSE, (Object)this.executionService.getVariable(processInstance.getId(), "basicBooleanFalse"));
        CustomConfigurationsTest.assertEquals((Object)Boolean.TRUE, (Object)this.executionService.getVariable(processInstance.getId(), "objectBooleanTrue"));
        CustomConfigurationsTest.assertEquals((Object)Boolean.FALSE, (Object)this.executionService.getVariable(processInstance.getId(), "objectBooleanFalse"));
    }

    public void testCustomAutomaticExpr() {
        this.deployJpdlXmlString("<process name='CustomExpr'>  <start>    <transition to='c' />  </start>  <custom name='c' expr='#{custombehaviour}'>    <transition to='wait' />  </custom>  <state name='wait'/></process>");
        HashMap<String, MyCustomAutomatic> variables = new HashMap<String, MyCustomAutomatic>();
        variables.put("custombehaviour", new MyCustomAutomatic());
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomExpr", variables);
        CustomConfigurationsTest.assertTrue((boolean)processInstance.findActiveActivityNames().contains("wait"));
    }

    public void testCustomWaitExpr() {
        this.deployJpdlXmlString("<process name='CustomExpr'>  <start>    <transition to='c' />  </start>  <custom name='c' expr='#{custombehaviour}'>    <transition name='1' to='the 1st way' />    <transition name='2' to='the 2nd way' />    <transition name='3' to='the 3rd way' />  </custom>  <state name='the 1st way' />  <state name='the 2nd way' />  <state name='the 3rd way' /></process>");
        HashMap<String, MyCustomWait> variables = new HashMap<String, MyCustomWait>();
        variables.put("custombehaviour", new MyCustomWait());
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomExpr", variables);
        Set findActiveActivityNames = processInstance.findActiveActivityNames();
        CustomConfigurationsTest.assertTrue((boolean)findActiveActivityNames.contains("c"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        findActiveActivityNames = processInstance.findActiveActivityNames();
        CustomConfigurationsTest.assertTrue((boolean)findActiveActivityNames.contains("the 3rd way"));
    }

    public void testCustomUserObjectCachingDefault() {
        ActivityBehaviourWithId.nextObjectId = 1;
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + ActivityBehaviourWithId.class.getName() + "'>" + "    <transition to='wait' />" + "  </custom>" + "  <state name='wait'/>" + "</process>");
        String pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)1, (Object)this.executionService.getVariable(pid, "objectId"));
        pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)1, (Object)this.executionService.getVariable(pid, "objectId"));
        pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)1, (Object)this.executionService.getVariable(pid, "objectId"));
    }

    public void testCustomUserObjectCachingDisabled() {
        ActivityBehaviourWithId.nextObjectId = 1;
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' cache='false' class='" + ActivityBehaviourWithId.class.getName() + "'>" + "    <transition to='wait' />" + "  </custom>" + "  <state name='wait'/>" + "</process>");
        String pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)1, (Object)this.executionService.getVariable(pid, "objectId"));
        pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)2, (Object)this.executionService.getVariable(pid, "objectId"));
        pid = this.executionService.startProcessInstanceByKey("CustomClass").getId();
        CustomConfigurationsTest.assertEquals((Object)3, (Object)this.executionService.getVariable(pid, "objectId"));
    }

    public static class ActivityBehaviourWithId
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;
        private static int nextObjectId = 1;
        int objectId = nextObjectId++;

        public void execute(ActivityExecution execution) throws Exception {
            execution.setVariable("objectId", (Object)this.objectId);
        }
    }

    public static class MyCustomAutomaticWithFieldAndProperty
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;
        String text;
        Long objectLong;
        int basicInt;
        Integer objectInt;
        long basicLong;
        float basicFloat;
        Float objectFloat;
        double basicDouble;
        Double objectDouble;
        boolean basicBooleanTrue;
        boolean basicBooleanFalse;
        Boolean objectBooleanTrue;
        Boolean objectBooleanFalse;

        public void execute(ActivityExecution execution) throws Exception {
            execution.setVariable("text", (Object)this.text);
            execution.setVariable("number", (Object)this.objectLong);
            execution.setVariable("basicInt", (Object)this.basicInt);
            execution.setVariable("objectInt", (Object)this.objectInt);
            execution.setVariable("basicLong", (Object)this.basicLong);
            execution.setVariable("basicFloat", (Object)Float.valueOf(this.basicFloat));
            execution.setVariable("objectFloat", (Object)this.objectFloat);
            execution.setVariable("basicDouble", (Object)this.basicDouble);
            execution.setVariable("objectDouble", (Object)this.objectDouble);
            execution.setVariable("basicBooleanTrue", (Object)this.basicBooleanTrue);
            execution.setVariable("basicBooleanFalse", (Object)this.basicBooleanFalse);
            execution.setVariable("objectBooleanTrue", (Object)this.objectBooleanTrue);
            execution.setVariable("objectBooleanFalse", (Object)this.objectBooleanFalse);
        }

        public void setNumberProperty(Long number) {
            this.objectLong = number;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MyCustomWait
    implements ExternalActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.waitForSignal();
        }

        public void signal(ActivityExecution execution, String signalName, Map<String, ?> parameters) throws Exception {
            execution.take("3");
        }
    }

    public static class MyCustomAutomatic
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
        }
    }
}

