/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.custom;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.test.JbpmTestCase;

public class CustomHistoryTest
extends JbpmTestCase {
    public void testCustomAutomaticClass() {
        this.deployJpdlXmlString("<process name='CustomClass'>  <start>    <transition to='c' />  </start>  <custom name='c' class='" + MyCustomAutomatic.class.getName() + "'>" + "    <transition to='wait' />" + "  </custom>" + "  <state name='wait'>" + "    <transition to='end' />" + "  </state>" + "  <end name='end'/>" + "</process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("CustomClass");
        CustomHistoryTest.assertTrue((boolean)processInstance.findActiveActivityNames().contains("wait"));
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        this.assertProcessInstanceEnded(processInstance);
        List histActivities = this.historyService.createHistoryActivityInstanceQuery().processInstanceId(processInstance.getId()).orderAsc("id").list();
        CustomHistoryTest.assertEquals((int)2, (int)histActivities.size());
        CustomHistoryTest.assertEquals((String)"c", (String)((HistoryActivityInstance)histActivities.get(0)).getActivityName());
        CustomHistoryTest.assertEquals((String)"wait", (String)((HistoryActivityInstance)histActivities.get(1)).getActivityName());
    }

    public static class MyCustomAutomatic
    implements ActivityBehaviour {
        private static final long serialVersionUID = 1L;

        public void execute(ActivityExecution execution) throws Exception {
            execution.takeDefaultTransition();
        }
    }
}

