/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.group;

import java.util.HashSet;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class GroupConcurrencyCombinationTest
extends JbpmTestCase {
    public void testGroupConcurrencyWithStartEndSignalFirstGroup() {
        this.deployJpdlXmlString("<process name='GroupConcurrency'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='group'/>    <transition to='concurrent-wait'/>  </fork>  <group name='group'>    <start name='group-start'>      <transition to='group-wait'/>    </start>    <state name='group-wait'>      <transition to='group-end'/>    </state>    <end name='group-end'/>    <transition to='join'/>  </group>  <state name='concurrent-wait'>    <transition to='join'/>  </state>  <join name='join'>     <transition to='end'/>  </join>  <state name='end'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("GroupConcurrency");
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("group-wait");
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        Execution executionInGroupWait = processInstance.findActiveExecutionIn("group-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInGroupWait);
        Execution executionInConcurrentWait = processInstance.findActiveExecutionIn("concurrent-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInConcurrentWait);
        processInstance = this.executionService.signalExecutionById(executionInGroupWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        processInstance = this.executionService.signalExecutionById(executionInConcurrentWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("end");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
    }

    public void testGroupConcurrencyWithStartEndSignalFirstConcurrent() {
        this.deployJpdlXmlString("<process name='GroupConcurrency'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='group'/>    <transition to='concurrent-wait'/>  </fork>  <group name='group'>    <start name='group-start'>      <transition to='group-wait'/>    </start>    <state name='group-wait'>      <transition to='group-end'/>    </state>    <end name='group-end'/>    <transition to='join'/>  </group>  <state name='concurrent-wait'>    <transition to='join'/>  </state>  <join name='join'>     <transition to='end'/>  </join>  <state name='end'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("GroupConcurrency");
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("group-wait");
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        Execution executionInGroupWait = processInstance.findActiveExecutionIn("group-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInGroupWait);
        Execution executionInConcurrentWait = processInstance.findActiveExecutionIn("concurrent-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInConcurrentWait);
        processInstance = this.executionService.signalExecutionById(executionInConcurrentWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("group-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        processInstance = this.executionService.signalExecutionById(executionInGroupWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("end");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
    }

    public void testGroupConcurrencyDirectTransitionsSignalFirstGroup() {
        this.deployJpdlXmlString("<process name='GroupConcurrency'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='group-wait'/>    <transition to='concurrent-wait'/>  </fork>  <group name='group'>    <state name='group-wait'>      <transition to='join'/>    </state>  </group>  <state name='concurrent-wait'>    <transition to='join'/>  </state>  <join name='join'>     <transition to='end'/>  </join>  <state name='end'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("GroupConcurrency");
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("group-wait");
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        Execution executionInGroupWait = processInstance.findActiveExecutionIn("group-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInGroupWait);
        Execution executionInConcurrentWait = processInstance.findActiveExecutionIn("concurrent-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInConcurrentWait);
        processInstance = this.executionService.signalExecutionById(executionInGroupWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        processInstance = this.executionService.signalExecutionById(executionInConcurrentWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("end");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
    }

    public void testGroupConcurrencyDirectTransitionsSignalFirstConcurrent() {
        this.deployJpdlXmlString("<process name='GroupConcurrency'>  <start>    <transition to='fork'/>  </start>  <fork name='fork'>    <transition to='group-wait'/>    <transition to='concurrent-wait'/>  </fork>  <group name='group'>    <state name='group-wait'>      <transition to='join'/>    </state>  </group>  <state name='concurrent-wait'>    <transition to='join'/>  </state>  <join name='join'>     <transition to='end'/>  </join>  <state name='end'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("GroupConcurrency");
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("group-wait");
        expectedActivityNames.add("concurrent-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        Execution executionInGroupWait = processInstance.findActiveExecutionIn("group-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInGroupWait);
        Execution executionInConcurrentWait = processInstance.findActiveExecutionIn("concurrent-wait");
        GroupConcurrencyCombinationTest.assertNotNull((Object)executionInConcurrentWait);
        processInstance = this.executionService.signalExecutionById(executionInConcurrentWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("group-wait");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        processInstance = this.executionService.signalExecutionById(executionInGroupWait.getId());
        expectedActivityNames = new HashSet();
        expectedActivityNames.add("end");
        GroupConcurrencyCombinationTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
    }
}

