/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.activity.subprocess;

import java.util.HashMap;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class SubProcessSignalTest
extends JbpmTestCase {
    private static final String SUB_PROCESS_WITH_WAIT_STATE = "<process name='SubProcessReview'>  <start>    <transition to='wait'/>  </start>  <state name='wait'>    <transition name='wait2' to='wait2'/>  </state>  <state name='wait2'>    <transition name='ok' to='ok'/>  </state>  <end name='ok' /></process>";
    private static final String MAIN_PROCESS_SUB_EL_ID = "<process name='mainProcess'>  <start>    <transition to='review' />  </start>  <sub-process name='review' sub-process-id='#{dynamic_subprocess}'>    <transition name='ok' to='next step'/>    <transition name='nok' to='update'/>    <transition name='reject' to='close'/>  </sub-process>  <state name='next step'>    <transition name='close' to='close'/>  </state>  <state name='update'>    <transition name='close' to='close'/>  </state>  <end name='close'/></process>";

    public void testSubProcessWithStateFailure() {
        this.deployJpdlXmlString(SUB_PROCESS_WITH_WAIT_STATE);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL_ID);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("dynamic_subprocess", "SubProcessReview-1");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
        try {
            processInstance = this.executionService.signalExecutionById(processInstance.getId());
            SubProcessSignalTest.fail((String)"Should fail since signal was made on a process with subprocess stil active");
        }
        catch (Exception e) {
            SubProcessSignalTest.assertTrue((e.getMessage().indexOf("has running subprocess") != -1 ? 1 : 0) != 0);
            this.executionService.signalExecutionById(processInstance.getSubProcessInstance().getId());
            this.executionService.signalExecutionById(processInstance.getSubProcessInstance().getId());
            processInstance = this.executionService.signalExecutionById(processInstance.getId());
        }
    }

    public void testSubProcessWithStateSuccess() {
        this.deployJpdlXmlString(SUB_PROCESS_WITH_WAIT_STATE);
        this.deployJpdlXmlString(MAIN_PROCESS_SUB_EL_ID);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("dynamic_subprocess", "SubProcessReview-1");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("mainProcess", vars);
        String subId = processInstance.getSubProcessInstance().getId();
        this.executionService.signalExecutionById(processInstance.getSubProcessInstance().getId());
        this.executionService.signalExecutionById(processInstance.getSubProcessInstance().getId());
        processInstance = this.executionService.signalExecutionById(processInstance.getId());
        this.assertProcessInstanceEnded(processInstance);
        ProcessInstance subProcessInstance = this.executionService.findProcessInstanceById(subId);
        SubProcessSignalTest.assertNull((Object)subProcessInstance);
    }
}

