/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.async;

import java.util.HashMap;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.activity.ActivityBehaviour;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class AsyncBasicsTest
extends JbpmTestCase {
    public void testAsyncAutomaticSequence() {
        this.deployJpdlXmlString("<process name='TwoAsyncStates'>  <start>    <transition to='a' />  </start>  <custom name='a' continue='async' class='" + DoABit.class.getName() + "'>" + "    <transition to='b' />" + "  </custom>" + "  <custom name='b' continue='async' class='" + DoALot.class.getName() + "'>" + "    <transition to='end' />" + "  </custom>" + "  <state name='end' />" + "</process>");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("done", "nothing");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TwoAsyncStates", variables);
        String processInstanceId = processInstance.getId();
        AsyncBasicsTest.assertEquals((String)"async", (String)processInstance.getState());
        AsyncBasicsTest.assertEquals((Object)"nothing", (Object)this.executionService.getVariable(processInstanceId, "done"));
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncBasicsTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        this.managementService.executeJob(job.getId());
        AsyncBasicsTest.assertEquals((Object)"a bit", (Object)this.executionService.getVariable(processInstanceId, "done"));
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        AsyncBasicsTest.assertEquals((String)"async", (String)processInstance.getState());
        jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncBasicsTest.assertEquals((int)1, (int)jobs.size());
        job = (Job)jobs.get(0);
        this.managementService.executeJob(job.getId());
        AsyncBasicsTest.assertEquals((Object)"a lot", (Object)this.executionService.getVariable(processInstanceId, "done"));
        processInstance = this.executionService.findProcessInstanceById(processInstanceId);
        AsyncBasicsTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    public void testAsyncTransitions() {
        this.deployJpdlXmlString("<process name='TwoAsyncStates'>  <start>    <transition to='a' />  </start>  <custom name='a' class='" + DoABit.class.getName() + "'>" + "    <transition continue='async' to='b' />" + "  </custom>" + "  <custom name='b' class='" + DoALot.class.getName() + "'>" + "    <transition continue='async' to='end' />" + "  </custom>" + "  <state name='end' />" + "</process>");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("done", "nothing");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TwoAsyncStates", variables);
        String processInstanceId = processInstance.getId();
        AsyncBasicsTest.assertEquals((String)"async", (String)processInstance.getState());
        AsyncBasicsTest.assertEquals((Object)"a bit", (Object)this.executionService.getVariable(processInstanceId, "done"));
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncBasicsTest.assertEquals((int)1, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        this.managementService.executeJob(job.getId());
        AsyncBasicsTest.assertEquals((Object)"a lot", (Object)this.executionService.getVariable(processInstanceId, "done"));
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        AsyncBasicsTest.assertEquals((String)"async", (String)processInstance.getState());
        jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        AsyncBasicsTest.assertEquals((int)1, (int)jobs.size());
        job = (Job)jobs.get(0);
        this.managementService.executeJob(job.getId());
        processInstance = this.executionService.findProcessInstanceById(processInstanceId);
        AsyncBasicsTest.assertTrue((boolean)processInstance.isActive("end"));
    }

    public void testExecutionBlockedDuringAsync() {
        this.deployJpdlXmlString("<process name='AsyncState'>  <start>    <transition to='a' />  </start>  <state name='a' continue='async'>    <transition to='end' />  </state>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncState");
        try {
            this.executionService.signalExecutionById(processInstance.getId());
            AsyncBasicsTest.fail((String)"expected exception");
        }
        catch (Exception e) {
            this.assertTextPresent("execution", e.getMessage());
            this.assertTextPresent("is not active: async", e.getMessage());
        }
    }

    public void testAsyncStart() {
        this.deployJpdlXmlString("<process name='AsyncStart'>  <start continue='async' name='start'>    <transition to='end' />  </start>  <end name='end' /></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncStart");
        String processInstanceId = processInstance.getId();
        AsyncBasicsTest.assertEquals((String)"async", (String)processInstance.getState());
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        AsyncBasicsTest.assertEquals((int)1, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.assertProcessInstanceEnded(processInstanceId);
    }

    public static class DoALot
    implements ActivityBehaviour {
        public void execute(ActivityExecution execution) {
            execution.setVariable("done", (Object)"a lot");
        }
    }

    public static class DoABit
    implements ActivityBehaviour {
        public void execute(ActivityExecution execution) {
            execution.setVariable("done", (Object)"a bit");
        }
    }
}

