/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.deploy;

import java.util.HashSet;
import java.util.List;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendDeploymentTest
extends JbpmTestCase {
    public void testSuspendDeployment() {
        this.deployJpdlXmlString("<process name='claim'>  <start>    <transition to='c' />  </start>  <state name='c' /></process>");
        String deploymentHireId = this.deployJpdlXmlString("<process name='hire'>  <start>    <transition to='h' />  </start>  <state name='h' /></process>");
        this.deployJpdlXmlString("<process name='fire'>  <start>    <transition to='f' />  </start>  <state name='f' /></process>");
        HashSet<String> expectedProcessNames = new HashSet<String>();
        expectedProcessNames.add("claim");
        expectedProcessNames.add("hire");
        expectedProcessNames.add("fire");
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        SuspendDeploymentTest.assertEquals(expectedProcessNames, (Object)this.getProcessDefinitionNames(processDefinitions));
        this.executionService.startProcessInstanceByKey("claim");
        this.executionService.startProcessInstanceByKey("claim");
        this.executionService.startProcessInstanceByKey("hire");
        this.executionService.startProcessInstanceByKey("hire");
        this.executionService.startProcessInstanceByKey("fire");
        this.executionService.startProcessInstanceByKey("fire");
        List processInstances = this.executionService.createProcessInstanceQuery().list();
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "claim"));
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "hire"));
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "fire"));
        SuspendDeploymentTest.assertEquals((int)6, (int)processInstances.size());
        this.repositoryService.suspendDeployment(deploymentHireId);
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        SuspendDeploymentTest.assertEquals(expectedProcessNames, (Object)this.getProcessDefinitionNames(processDefinitions));
        processInstances = this.executionService.createProcessInstanceQuery().notSuspended().list();
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "claim"));
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "fire"));
        SuspendDeploymentTest.assertEquals((int)4, (int)processInstances.size());
        this.repositoryService.resumeDeployment(deploymentHireId);
        expectedProcessNames.add("hire");
        processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        SuspendDeploymentTest.assertEquals(expectedProcessNames, (Object)this.getProcessDefinitionNames(processDefinitions));
        processInstances = this.executionService.createProcessInstanceQuery().list();
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "claim"));
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "hire"));
        SuspendDeploymentTest.assertEquals((int)2, (int)this.countProcessInstancesFor(processInstances, "fire"));
        SuspendDeploymentTest.assertEquals((int)6, (int)processInstances.size());
    }

    public void testQuerySuspendDeployments() {
        this.deployJpdlXmlString("<process name='claim'>  <start>    <transition to='c' />  </start>  <state name='c' /></process>");
        String deploymentHireId = this.deployJpdlXmlString("<process name='hire'>  <start>    <transition to='h' />  </start>  <state name='h' /></process>");
        String deploymentFireId = this.deployJpdlXmlString("<process name='fire'>  <start>    <transition to='f' />  </start>  <state name='f' /></process>");
        this.repositoryService.suspendDeployment(deploymentHireId);
        this.repositoryService.suspendDeployment(deploymentFireId);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().suspended().list();
        HashSet<String> expectedProcessNames = new HashSet<String>();
        expectedProcessNames.add("hire");
        expectedProcessNames.add("fire");
        SuspendDeploymentTest.assertEquals(expectedProcessNames, (Object)this.getProcessDefinitionNames(processDefinitions));
    }

    public void testQueryNonSuspendProcessDefinitions() {
        this.deployJpdlXmlString("<process name='claim'>  <start>    <transition to='c' />  </start>  <state name='c' /></process>");
        String deploymentHireId = this.deployJpdlXmlString("<process name='hire'>  <start>    <transition to='h' />  </start>  <state name='h' /></process>");
        String deploymentFireId = this.deployJpdlXmlString("<process name='fire'>  <start>    <transition to='f' />  </start>  <state name='f' /></process>");
        this.repositoryService.suspendDeployment(deploymentHireId);
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().notSuspended().list();
        HashSet<String> expectedProcessNames = new HashSet<String>();
        expectedProcessNames.add("claim");
        expectedProcessNames.add("fire");
        SuspendDeploymentTest.assertEquals(expectedProcessNames, (Object)this.getProcessDefinitionNames(processDefinitions));
    }

    int countProcessInstancesFor(List<ProcessInstance> processInstances, String processDefinitionKey) {
        int count = 0;
        for (ProcessInstance processInstance : processInstances) {
            if (!processInstance.getProcessDefinitionId().startsWith(processDefinitionKey)) continue;
            ++count;
        }
        return count;
    }

    Object getProcessDefinitionNames(List<ProcessDefinition> processDefinitions) {
        HashSet<String> processNames = new HashSet<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processNames.add(processDefinition.getName());
        }
        return processNames;
    }
}

