/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.history;

import java.util.Date;
import java.util.List;
import org.jbpm.api.TaskService;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.cmd.VoidCommand;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class HistoryTaskDetailTest
extends JbpmTestCase {
    private static final String PROCESS_XML = "<process name='HistoryTaskDetail'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>";

    protected void setUp() throws Exception {
        super.setUp();
        this.deployJpdlXmlString(PROCESS_XML);
    }

    public void testHistoryAssignment() {
        this.executionService.startProcessInstanceByKey("HistoryTaskDetail");
        List tasks = this.taskService.findPersonalTasks("johndoe");
        HistoryTaskDetailTest.assertEquals((int)1, (int)tasks.size());
        String taskId = ((Task)tasks.get(0)).getId();
        this.processEngine.execute((Command)new TaskReassignCmd(taskId, "Lingo"));
        HistoryTaskDetailTest.assertEquals((int)1, (int)this.taskService.findPersonalTasks("Lingo").size());
        HistoryTaskDetailTest.assertEquals((int)1, (int)this.historyService.createHistoryDetailQuery().list().size());
    }

    public void testHistoryPriority() {
        this.executionService.startProcessInstanceByKey("HistoryTaskDetail");
        List tasks = this.taskService.findPersonalTasks("johndoe");
        HistoryTaskDetailTest.assertEquals((int)1, (int)tasks.size());
        String taskId = ((Task)tasks.get(0)).getId();
        this.processEngine.execute((Command)new TaskChangePriorityCmd(taskId, 10));
        HistoryTaskDetailTest.assertEquals((int)1, (int)this.historyService.createHistoryDetailQuery().list().size());
    }

    public void testHistoryDuedate() {
        this.executionService.startProcessInstanceByKey("HistoryTaskDetail");
        List tasks = this.taskService.findPersonalTasks("johndoe");
        HistoryTaskDetailTest.assertEquals((int)1, (int)tasks.size());
        String taskId = ((Task)tasks.get(0)).getId();
        this.processEngine.execute((Command)new TaskChangeDuedateCmd(taskId, new Date()));
        HistoryTaskDetailTest.assertEquals((int)1, (int)this.historyService.createHistoryDetailQuery().list().size());
    }

    private static class TaskChangeDuedateCmd
    extends VoidCommand {
        private String taskId;
        private Date newDuedate;
        private static final long serialVersionUID = 1L;

        TaskChangeDuedateCmd(String taskId, Date newDuedate) {
            this.taskId = taskId;
            this.newDuedate = newDuedate;
        }

        protected void executeVoid(Environment environment) throws Exception {
            TaskService taskService = (TaskService)environment.get(TaskService.class);
            Task task = taskService.getTask(this.taskId);
            task.setDuedate(this.newDuedate);
            taskService.saveTask(task);
        }
    }

    private static class TaskChangePriorityCmd
    extends VoidCommand {
        private String taskId;
        private int newPriority;
        private static final long serialVersionUID = 1L;

        TaskChangePriorityCmd(String taskId, int newPriority) {
            this.taskId = taskId;
            this.newPriority = newPriority;
        }

        protected void executeVoid(Environment environment) throws Exception {
            TaskService taskService = (TaskService)environment.get(TaskService.class);
            Task task = taskService.getTask(this.taskId);
            task.setPriority(this.newPriority);
            taskService.saveTask(task);
        }
    }

    private static class TaskReassignCmd
    extends VoidCommand {
        private String taskId;
        private String newAssignee;
        private static final long serialVersionUID = 1L;

        TaskReassignCmd(String taskId, String newAssignee) {
            this.taskId = taskId;
            this.newAssignee = newAssignee;
        }

        protected void executeVoid(Environment environment) throws Exception {
            TaskService taskService = (TaskService)environment.get(TaskService.class);
            Task task = taskService.getTask(this.taskId);
            task.setAssignee(this.newAssignee);
            taskService.saveTask(task);
        }
    }
}

