/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.migration;

import java.util.HashSet;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.pvm.internal.migration.MigrationDescriptor;
import org.jbpm.pvm.internal.migration.MigrationHandler;
import org.jbpm.test.JbpmTestCase;

public class InstanceMigratorTest
extends JbpmTestCase {
    private String originalVersion = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/></process>";
    private String versionWithMigrationHandler = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances>    <migration-handler class='org.jbpm.test.migration.InstanceMigratorTest$TestHandler'/>  </migrate-instances></process>";
    private String versionWithAbortion = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances action='end'>    <migration-handler class='org.jbpm.test.migration.InstanceMigratorTest$TestHandler'/>  </migrate-instances></process>";
    private String versionWithSimpleMigration = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances/></process>";
    private String versionWithCorrectMappings = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='d'/>  </state>  <state name='d'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances>    <activity-mapping old-name='b' new-name='a'/>    <activity-mapping old-name='c' new-name='d'/>  </migrate-instances></process>";
    private String versionWithIncorrectMappings = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='d'/>  </state>  <end name='end'/>  <migrate-instances>    <activity-mapping old-name='a' new-name='z'/>    <activity-mapping old-name='b' new-name='c'/>  </migrate-instances></process>";
    private String versionWithAbsoluteVersionRange = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances versions='2..3'/></process>";
    private String versionWithRelativeVersionRange = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances versions='x-2..x'/></process>";
    private String versionWithMixedVersionRange = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances versions='1..x-3'/></process>";
    private String versionWithWildcardVersionRange = "<process name='foobar'>  <start>    <transition to='a'/>  </start>  <state name='a'>    <transition to='b'/>  </state>  <state name='b'>    <transition to='c'/>  </state>  <state name='c'>    <transition to='end'/>  </state>  <end name='end'/>  <migrate-instances versions='*'/></process>";
    private static HashSet<String> PROCESS_INSTANCES_SET = new HashSet();

    protected void tearDown() throws Exception {
        PROCESS_INSTANCES_SET.clear();
        super.tearDown();
    }

    private ProcessDefinition deployProcessDefinition(String name, String processDefinitionXml) {
        String deploymentId = this.repositoryService.createDeployment().addResourceFromString(name + ".jpdl.xml", processDefinitionXml).deploy();
        return this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).uniqueResult();
    }

    private ProcessInstance startAndSignal(ProcessDefinition processDefinition, String endActivityName) {
        ProcessInstance result = this.executionService.startProcessInstanceById(processDefinition.getId());
        while (result.findActiveExecutionIn(endActivityName) == null) {
            result = this.executionService.signalExecutionById(result.getId());
        }
        return result;
    }

    public void testNoProcessInstanceForMigration() {
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.versionWithWildcardVersionRange);
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testNoMigration() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessInstance pi2 = this.startAndSignal(pd1, "b");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.originalVersion);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        InstanceMigratorTest.assertEquals((String)pd1.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd1.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertTrue((boolean)pi1.findActiveActivityNames().contains("a"));
        InstanceMigratorTest.assertTrue((boolean)pi2.findActiveActivityNames().contains("b"));
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testMigrationHandler() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessInstance pi2 = this.startAndSignal(pd1, "b");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.versionWithMigrationHandler);
        InstanceMigratorTest.assertTrue((boolean)PROCESS_INSTANCES_SET.contains(pi1.getId()));
        InstanceMigratorTest.assertTrue((boolean)PROCESS_INSTANCES_SET.contains(pi2.getId()));
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((Object)pi1, (Object)pi1.findActiveExecutionIn("a"));
        InstanceMigratorTest.assertEquals((Object)pi2, (Object)pi2.findActiveExecutionIn("b"));
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testSimpleAbortion() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessInstance pi2 = this.startAndSignal(pd1, "b");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.versionWithAbortion);
        InstanceMigratorTest.assertTrue((boolean)PROCESS_INSTANCES_SET.contains(pi1.getId()));
        InstanceMigratorTest.assertTrue((boolean)PROCESS_INSTANCES_SET.contains(pi2.getId()));
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        InstanceMigratorTest.assertNull((Object)pi1);
        InstanceMigratorTest.assertNull((Object)pi2);
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testSimpleMigration() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessInstance pi2 = this.startAndSignal(pd1, "b");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.versionWithSimpleMigration);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((Object)pi1, (Object)pi1.findActiveExecutionIn("a"));
        InstanceMigratorTest.assertEquals((Object)pi2, (Object)pi2.findActiveExecutionIn("b"));
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testCorrectlyMappedMigration() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessInstance pi2 = this.startAndSignal(pd1, "b");
        ProcessInstance pi3 = this.startAndSignal(pd1, "c");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.versionWithCorrectMappings);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi3.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((Object)pi1, (Object)pi1.findActiveExecutionIn("a"));
        InstanceMigratorTest.assertEquals((Object)pi2, (Object)pi2.findActiveExecutionIn("a"));
        InstanceMigratorTest.assertEquals((Object)pi3, (Object)pi3.findActiveExecutionIn("d"));
        pi1 = this.executionService.signalExecutionById(pi1.getId());
        pi2 = this.executionService.signalExecutionById(pi2.getId());
        pi2 = this.executionService.signalExecutionById(pi2.getId());
        pi3 = this.executionService.signalExecutionById(pi3.getId());
        InstanceMigratorTest.assertEquals((Object)pi1, (Object)pi1.findActiveExecutionIn("b"));
        InstanceMigratorTest.assertEquals((Object)pi2, (Object)pi2.findActiveExecutionIn("c"));
        InstanceMigratorTest.assertTrue((boolean)pi3.isEnded());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        InstanceMigratorTest.assertNull((Object)pi3);
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
    }

    public void testIncorrectlyMappedMigration() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        this.startAndSignal(pd1, "a");
        this.startAndSignal(pd1, "b");
        try {
            this.deployProcessDefinition("foobar", this.versionWithIncorrectMappings);
            InstanceMigratorTest.fail();
        }
        catch (JbpmException e) {
            this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        }
    }

    public void testAbsoluteVersionRange() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi2 = this.startAndSignal(pd2, "a");
        ProcessDefinition pd3 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi3 = this.startAndSignal(pd3, "a");
        ProcessDefinition pd4 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi4 = this.startAndSignal(pd4, "a");
        ProcessDefinition pd5 = this.deployProcessDefinition("foobar", this.versionWithAbsoluteVersionRange);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        pi4 = this.executionService.findProcessInstanceById(pi4.getId());
        InstanceMigratorTest.assertEquals((String)pd1.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi3.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd4.getId(), (String)pi4.getProcessDefinitionId());
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd3.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd4.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd5.getDeploymentId());
    }

    public void testRelativeVersionRange() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi2 = this.startAndSignal(pd2, "a");
        ProcessDefinition pd3 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi3 = this.startAndSignal(pd3, "a");
        ProcessDefinition pd4 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi4 = this.startAndSignal(pd4, "a");
        ProcessDefinition pd5 = this.deployProcessDefinition("foobar", this.versionWithRelativeVersionRange);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        pi4 = this.executionService.findProcessInstanceById(pi4.getId());
        InstanceMigratorTest.assertEquals((String)pd1.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd2.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi3.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi4.getProcessDefinitionId());
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd3.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd4.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd5.getDeploymentId());
    }

    public void testMixedVersionRange() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi2 = this.startAndSignal(pd2, "a");
        ProcessDefinition pd3 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi3 = this.startAndSignal(pd3, "a");
        ProcessDefinition pd4 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi4 = this.startAndSignal(pd4, "a");
        ProcessDefinition pd5 = this.deployProcessDefinition("foobar", this.versionWithMixedVersionRange);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        pi4 = this.executionService.findProcessInstanceById(pi4.getId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd3.getId(), (String)pi3.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd4.getId(), (String)pi4.getProcessDefinitionId());
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd3.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd4.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd5.getDeploymentId());
    }

    public void testWildcardVersionRange() {
        ProcessDefinition pd1 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi1 = this.startAndSignal(pd1, "a");
        ProcessDefinition pd2 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi2 = this.startAndSignal(pd2, "a");
        ProcessDefinition pd3 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi3 = this.startAndSignal(pd3, "a");
        ProcessDefinition pd4 = this.deployProcessDefinition("foobar", this.originalVersion);
        ProcessInstance pi4 = this.startAndSignal(pd4, "a");
        ProcessDefinition pd5 = this.deployProcessDefinition("foobar", this.versionWithWildcardVersionRange);
        pi1 = this.executionService.findProcessInstanceById(pi1.getId());
        pi2 = this.executionService.findProcessInstanceById(pi2.getId());
        pi3 = this.executionService.findProcessInstanceById(pi3.getId());
        pi4 = this.executionService.findProcessInstanceById(pi4.getId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi1.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi2.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi3.getProcessDefinitionId());
        InstanceMigratorTest.assertEquals((String)pd5.getId(), (String)pi4.getProcessDefinitionId());
        this.repositoryService.deleteDeploymentCascade(pd1.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd2.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd3.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd4.getDeploymentId());
        this.repositoryService.deleteDeploymentCascade(pd5.getDeploymentId());
    }

    public static class TestHandler
    implements MigrationHandler {
        public void migrateInstance(ProcessDefinition processDefinition, ProcessInstance processInstance, MigrationDescriptor migrationDescriptor) {
            PROCESS_INSTANCES_SET.add(processInstance.getId());
        }
    }
}

