/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.pvm.internal.util.IoUtil;
import org.jbpm.test.JbpmTestCase;

public class ProcessDefinitionStartFormTest
extends JbpmTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormInUnnamedStartActivity() throws IOException {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", "<process name='make print'>  <start form='org/jbpm/test/process/ProcessDefinitionStartForm.form' /></process>").addResourceFromClasspath("org/jbpm/test/process/ProcessDefinitionStartForm.form").deploy();
        this.registerDeployment(deploymentDbid);
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("make print").uniqueResult();
        String processDefinitionId = processDefinition.getId();
        List startActivityNames = this.repositoryService.getStartActivityNames(processDefinitionId);
        ArrayList<Object> expectedStartActivityNames = new ArrayList<Object>();
        expectedStartActivityNames.add(null);
        ProcessDefinitionStartFormTest.assertEquals(expectedStartActivityNames, (Object)startActivityNames);
        String startFormResourceName = this.repositoryService.getStartFormResourceName(processDefinitionId, null);
        ProcessDefinitionStartFormTest.assertEquals((String)"org/jbpm/test/process/ProcessDefinitionStartForm.form", (String)startFormResourceName);
        InputStream formStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), startFormResourceName);
        try {
            ProcessDefinitionStartFormTest.assertEquals((String)"start task form", (String)new String(IoUtil.readBytes((InputStream)formStream)));
        }
        finally {
            IoUtil.close((Closeable)formStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFormInNamedStartActivity() throws IOException {
        String deploymentDbid = this.repositoryService.createDeployment().addResourceFromString("xmlstring.jpdl.xml", "<process name='make print'>  <start name='start' form='org/jbpm/test/process/ProcessDefinitionStartForm.form' /></process>").addResourceFromClasspath("org/jbpm/test/process/ProcessDefinitionStartForm.form").deploy();
        this.registerDeployment(deploymentDbid);
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionName("make print").uniqueResult();
        String processDefinitionId = processDefinition.getId();
        List startActivityNames = this.repositoryService.getStartActivityNames(processDefinitionId);
        ArrayList<String> expectedStartActivityNames = new ArrayList<String>();
        expectedStartActivityNames.add("start");
        ProcessDefinitionStartFormTest.assertEquals(expectedStartActivityNames, (Object)startActivityNames);
        String startFormResourceName = this.repositoryService.getStartFormResourceName(processDefinitionId, "start");
        ProcessDefinitionStartFormTest.assertEquals((String)"org/jbpm/test/process/ProcessDefinitionStartForm.form", (String)startFormResourceName);
        InputStream formStream = this.repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), startFormResourceName);
        try {
            ProcessDefinitionStartFormTest.assertEquals((String)"start task form", (String)new String(IoUtil.readBytes((InputStream)formStream)));
        }
        finally {
            IoUtil.close((Closeable)formStream);
        }
    }
}

