/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.api.history.HistoryDetail;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.assertion.QueryAssertions;

public class HistoryDetailQueryTest
extends JbpmTestCase {
    public void testProcessInstance() {
        this.deployJpdlXmlString("<process name='HistoryDetails'>  <start>    <transition to='review' />  </start>  <task name='review'         assignee='johndoe'>    <transition to='wait' />  </task>  <state name='wait'/></process>");
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("HistoryDetails");
        String pid = processInstance.getId();
        List processInstanceHistoryDetails = this.historyService.createHistoryDetailQuery().processInstanceId(pid).list();
        HistoryDetailQueryTest.assertNotNull((Object)processInstanceHistoryDetails);
        HistoryDetailQueryTest.assertEquals((int)0, (int)processInstanceHistoryDetails.size());
    }

    public void testTaskCommentDetail() {
        this.deployJpdlXmlString("<process name='TaskCommentDetail'>  <start>    <transition to='t' />  </start>  <task name='t' assignee='johndoe'/></process>");
        this.executionService.startProcessInstanceByKey("TaskCommentDetail");
        String taskId = this.taskService.createTaskQuery().uniqueResult().getId();
        this.taskService.addTaskComment(taskId, "hello");
        List historyDetails = this.historyService.createHistoryDetailQuery().list();
        HistoryDetailQueryTest.assertEquals((String)historyDetails.toString(), (int)1, (int)historyDetails.size());
        historyDetails = this.historyService.createHistoryDetailQuery().comments().list();
        HistoryDetailQueryTest.assertEquals((String)historyDetails.toString(), (int)1, (int)historyDetails.size());
        HistoryComment historyComment = (HistoryComment)historyDetails.get(0);
        HistoryDetailQueryTest.assertEquals((String)"hello", (String)historyComment.getMessage());
    }

    public void testTaskCommentRepliesDetail() {
        this.deployJpdlXmlString("<process name='TaskCommentRepliesDetail'>  <start>    <transition to='t' />  </start>  <task name='t' assignee='johndoe'/></process>");
        this.executionService.startProcessInstanceByKey("TaskCommentRepliesDetail");
        String taskId = this.taskService.createTaskQuery().uniqueResult().getId();
        this.processEngine.setAuthenticatedUserId("johndoe");
        String helloCommentId = this.taskService.addTaskComment(taskId, "hi, how are you guys?").getId();
        this.processEngine.setAuthenticatedUserId("joesmoe");
        this.taskService.addReplyComment(helloCommentId, "i'm doing fine, thanks");
        this.processEngine.setAuthenticatedUserId("jackblack");
        this.taskService.addReplyComment(helloCommentId, "i got a hangover");
        List historyDetails = this.historyService.createHistoryDetailQuery().list();
        HistoryDetailQueryTest.assertEquals((String)historyDetails.toString(), (int)3, (int)historyDetails.size());
        historyDetails = this.historyService.createHistoryDetailQuery().comments().list();
    }

    public void testOrderBy() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.addTaskComment(task.getId(), "aaaaaaa");
        this.taskService.addTaskComment(task.getId(), "xxxxxxx");
        String commentId = this.taskService.addTaskComment(task.getId(), "ggggggg").getId();
        this.taskService.addReplyComment(commentId, "jjjjjj");
        List listAsc = this.historyService.createHistoryDetailQuery().orderAsc("time").list();
        List listDesc = this.historyService.createHistoryDetailQuery().orderDesc("time").list();
        QueryAssertions.assertOrderIsNatural(HistoryDetail.class, (String)"time", (List)listAsc, (List)listDesc, (int)4);
        this.taskService.deleteTaskCascade(task.getId());
    }
}

