/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.api.Deployment;
import org.jbpm.api.JbpmException;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.ProcessInstanceQuery;
import org.jbpm.test.JbpmTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInstanceQueryTest
extends JbpmTestCase {
    private static final String TEST_PROCESS_1_KEY = "testProcess1";
    private static final String TEST_PROCESS_1 = "<process name='testProcess1'>  <start>    <transition to='a' />  </start>  <state name='a'>    <transition to='end' />  </state>  <end name='end' /></process>";
    private static final String TEST_PROCESS_2_KEY = "testProcess2";
    private static final String TEST_PROCESS_2 = "<process name='testProcess2'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='assemble product' />    <transition to='print documents' />  </fork>  <task name='assemble product' assignee='johndoe'>    <transition to='j' />  </task>  <task name='print documents' assignee='johndoe'>    <transition to='j' />  </task>  <join name='j'>    <transition to='end' />  </join>  <end name='end' /></process>";

    public void testQueryByProcessInstanceId() {
        ProcessInstance pi;
        Map<String, ArrayList<String>> processInstanceIds = this.startTestProcesses(3, 7);
        List idsForTestProcess1 = processInstanceIds.get(TEST_PROCESS_1_KEY);
        List idsForTestProcess2 = processInstanceIds.get(TEST_PROCESS_2_KEY);
        for (String processInstanceId : idsForTestProcess1) {
            pi = this.executionService.createProcessInstanceQuery().processInstanceId(processInstanceId).uniqueResult();
            ProcessInstanceQueryTest.assertNotNull((Object)pi);
        }
        for (String processInstanceId : idsForTestProcess2) {
            pi = this.executionService.createProcessInstanceQuery().processInstanceId(processInstanceId).uniqueResult();
            ProcessInstanceQueryTest.assertNotNull((Object)pi);
        }
    }

    public void testQueryByProcessInstanceKey() {
        ProcessInstance pi;
        int i;
        this.startTestProcesses(7, 8);
        for (i = 0; i < 7; ++i) {
            pi = this.executionService.createProcessInstanceQuery().processInstanceKey("testProcess1-" + i).uniqueResult();
            ProcessInstanceQueryTest.assertNotNull((Object)pi);
        }
        for (i = 0; i < 8; ++i) {
            pi = this.executionService.createProcessInstanceQuery().processInstanceKey("testProcess2-" + i).uniqueResult();
            ProcessInstanceQueryTest.assertNotNull((Object)pi);
        }
    }

    public void testQueryByProcessDefinitionId() {
        this.startTestProcesses(10, 6);
        ProcessDefinition definitionProcess1 = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(TEST_PROCESS_1_KEY).uniqueResult();
        ProcessDefinition definitionProcess2 = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(TEST_PROCESS_2_KEY).uniqueResult();
        List processInstances = this.executionService.createProcessInstanceQuery().processDefinitionId(definitionProcess1.getId()).list();
        ProcessInstanceQueryTest.assertEquals((int)10, (int)processInstances.size());
        processInstances = this.executionService.createProcessInstanceQuery().processDefinitionId(definitionProcess2.getId()).list();
        ProcessInstanceQueryTest.assertEquals((int)6, (int)processInstances.size());
    }

    public void testQueryBySuspended() {
        this.startTestProcesses(6, 0);
        Deployment deployment = this.repositoryService.createDeploymentQuery().uniqueResult();
        this.repositoryService.suspendDeployment(deployment.getId());
        List processInstances = this.executionService.createProcessInstanceQuery().suspended().list();
        ProcessInstanceQueryTest.assertEquals((int)6, (int)processInstances.size());
    }

    public void testQueryByNotSuspended() {
        this.startTestProcesses(5, 5);
        ProcessInstanceQuery query = this.executionService.createProcessInstanceQuery().notSuspended();
        List processInstances = query.list();
        ProcessInstanceQueryTest.assertEquals((int)10, (int)processInstances.size());
        List deployments = this.repositoryService.createDeploymentQuery().list();
        ProcessInstanceQueryTest.assertEquals((int)2, (int)deployments.size());
        this.repositoryService.suspendDeployment(((Deployment)deployments.get(0)).getId());
        processInstances = query.list();
        ProcessInstanceQueryTest.assertEquals((int)5, (int)processInstances.size());
    }

    public void testQueryByPage() {
        this.startTestProcesses(8, 12);
        for (int i = 0; i < 20; i += 2) {
            List processInstances = this.executionService.createProcessInstanceQuery().page(i, 2).list();
            ProcessInstanceQueryTest.assertEquals((int)2, (int)processInstances.size());
        }
    }

    public void testOrderByAscKey() {
        this.startTestProcesses(6, 10);
        List processInstances = this.executionService.createProcessInstanceQuery().orderAsc("key").list();
        ProcessInstanceQueryTest.assertEquals((int)16, (int)processInstances.size());
        for (int i = 0; i < processInstances.size(); ++i) {
            if (i < 6) {
                ProcessInstanceQueryTest.assertTrue((boolean)((ProcessInstance)processInstances.get(i)).getKey().startsWith(TEST_PROCESS_1_KEY));
                continue;
            }
            ProcessInstanceQueryTest.assertTrue((boolean)((ProcessInstance)processInstances.get(i)).getKey().startsWith(TEST_PROCESS_2_KEY));
        }
    }

    public void testOrderByDescKey() {
        this.startTestProcesses(5, 9);
        List processInstances = this.executionService.createProcessInstanceQuery().orderDesc("key").list();
        ProcessInstanceQueryTest.assertEquals((int)14, (int)processInstances.size());
        for (int i = 0; i < processInstances.size(); ++i) {
            if (i < 9) {
                ProcessInstanceQueryTest.assertTrue((boolean)((ProcessInstance)processInstances.get(i)).getKey().startsWith(TEST_PROCESS_2_KEY));
                continue;
            }
            ProcessInstanceQueryTest.assertTrue((boolean)((ProcessInstance)processInstances.get(i)).getKey().startsWith(TEST_PROCESS_1_KEY));
        }
    }

    public void testCount() {
        Map<String, ArrayList<String>> processInstanceIds = this.startTestProcesses(4, 6);
        List idsForTestProcess1 = processInstanceIds.get(TEST_PROCESS_1_KEY);
        ProcessInstanceQueryTest.assertEquals((long)10L, (long)this.executionService.createProcessInstanceQuery().count());
        for (String processInstanceId : idsForTestProcess1) {
            ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.executionService.createProcessInstanceQuery().processInstanceId(processInstanceId).count());
        }
        for (int i = 0; i < 6; ++i) {
            ProcessInstanceQueryTest.assertEquals((long)1L, (long)this.executionService.createProcessInstanceQuery().processInstanceKey("testProcess2-" + i).count());
        }
        try {
            this.executionService.createProcessInstanceQuery().page(0, 3).count();
            ProcessInstanceQueryTest.fail((String)"expected exception");
        }
        catch (JbpmException jbpmException) {
            // empty catch block
        }
    }

    private Map<String, ArrayList<String>> startTestProcesses(int nrOfTestProcess1, int nrOfTestProcess2) {
        ProcessInstance pi;
        int i;
        if (nrOfTestProcess1 > 0) {
            this.deployJpdlXmlString(TEST_PROCESS_1);
        }
        if (nrOfTestProcess2 > 0) {
            this.deployJpdlXmlString(TEST_PROCESS_2);
        }
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        result.put(TEST_PROCESS_1_KEY, new ArrayList());
        result.put(TEST_PROCESS_2_KEY, new ArrayList());
        for (i = 0; i < nrOfTestProcess1; ++i) {
            pi = this.executionService.startProcessInstanceByKey(TEST_PROCESS_1_KEY, "testProcess1-" + i);
            ((ArrayList)result.get(TEST_PROCESS_1_KEY)).add(pi.getId());
        }
        for (i = 0; i < nrOfTestProcess2; ++i) {
            pi = this.executionService.startProcessInstanceByKey(TEST_PROCESS_2_KEY, "testProcess2-" + i);
            ((ArrayList)result.get(TEST_PROCESS_2_KEY)).add(pi.getId());
        }
        return result;
    }
}

