/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.util.Clock;
import org.jbpm.test.JbpmTestCase;

public class TaskDueDateTest
extends JbpmTestCase {
    public void testBaseDate() {
        this.deployJpdlXmlString("<process name='BaseDate'>  <start><transition to='t'/></start>  <task name='t' duedate='#{tomorrow}'/></process>");
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        tomorrow.set(14, 0);
        Map<String, Calendar> variables = Collections.singletonMap("tomorrow", tomorrow);
        String processInstanceId = this.executionService.startProcessInstanceByKey("BaseDate", variables).getId();
        List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        TaskDueDateTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        TaskDueDateTest.assertEquals((Object)tomorrow.getTime(), (Object)task.getDuedate());
    }

    public void testBaseDatePlusDuration() {
        this.deployJpdlXmlString("<process name='BaseDatePlusDuration'>  <start><transition to='t'/></start>  <task name='t' duedate='#{tomorrow} + 1 hour'/></process>");
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        tomorrow.set(14, 0);
        Map<String, Calendar> variables = Collections.singletonMap("tomorrow", tomorrow);
        String processInstanceId = this.executionService.startProcessInstanceByKey("BaseDatePlusDuration", variables).getId();
        List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        TaskDueDateTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        tomorrow.add(10, 1);
        TaskDueDateTest.assertEquals((Object)tomorrow.getTime(), (Object)task.getDuedate());
    }

    public void testBaseDateMinusDuration() {
        this.deployJpdlXmlString("<process name='BaseDateMinusDuration'>  <start><transition to='t'/></start>  <task name='t' duedate='#{tomorrow} - 1 hour'/></process>");
        Calendar tomorrow = Calendar.getInstance();
        tomorrow.add(5, 1);
        tomorrow.set(14, 0);
        Map<String, Calendar> variables = Collections.singletonMap("tomorrow", tomorrow);
        String processInstanceId = this.executionService.startProcessInstanceByKey("BaseDateMinusDuration", variables).getId();
        List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        TaskDueDateTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        tomorrow.add(10, -1);
        TaskDueDateTest.assertEquals((Object)tomorrow.getTime(), (Object)task.getDuedate());
    }

    public void testDuration() {
        this.deployJpdlXmlString("<process name='Duration'>  <start><transition to='t'/></start>  <task name='t' duedate='1 hour'/></process>");
        Calendar now = Calendar.getInstance();
        now.set(14, 0);
        Clock.setExplicitTime((Date)now.getTime());
        String processInstanceId = this.executionService.startProcessInstanceByKey("Duration").getId();
        List taskList = this.taskService.createTaskQuery().processInstanceId(processInstanceId).list();
        TaskDueDateTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        now.add(10, 1);
        TaskDueDateTest.assertEquals((long)now.getTimeInMillis(), (long)task.getDuedate().getTime());
        Clock.setExplicitTime(null);
    }
}

