/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task;

import java.util.HashMap;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskPropertiesTest
extends JbpmTestCase {
    private static final String ACTOR = "johnDoe";
    private static final String ACTOR2 = "johnSmoe";
    private static final String PROCESS = "<process name='VacationTrip'>  <start>    <transition to='f' />  </start>  <fork name='f'>    <transition to='select destination' />    <transition to='work hard for the money' />  </fork>  <task name='select destination' assignee='johnDoe'> <description>Description for 'select destination' with #{timeframe}</description>    <transition to='wait' />  </task>  <task name='work hard for the money' assignee='johnSmoe_not_the_same'>    <transition to='wait' />  </task>  <state name='wait'/></process>";

    public void testGetActivityName() {
        Task task = this.startProcessInstanceAndReturnTaskFor(ACTOR);
        TaskPropertiesTest.assertEquals((String)"select destination", (String)task.getActivityName());
    }

    public void testGetDescription() {
        Task task = this.startProcessInstanceAndReturnTaskFor(ACTOR);
        TaskPropertiesTest.assertEquals((String)"Description for 'select destination' with Springbreak", (String)task.getDescription());
    }

    public void testGetProcessDefinitionThroughTask() {
        Task task = this.startProcessInstanceAndReturnTaskFor(ACTOR);
        String pdId = this.executionService.findExecutionById(task.getExecutionId()).getProcessDefinitionId();
        ProcessDefinition processDefinition = this.repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).uniqueResult();
        TaskPropertiesTest.assertEquals((String)"VacationTrip", (String)processDefinition.getName());
    }

    private Task startProcessInstanceAndReturnTaskFor(String actor) {
        this.deployJpdlXmlString(PROCESS);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("timeframe", "Springbreak");
        this.executionService.startProcessInstanceByKey("VacationTrip", vars);
        return (Task)this.taskService.findPersonalTasks(actor).get(0);
    }
}

