/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.task.multiple;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;
import org.subethamail.wiser.Wiser;

public class MultipleTasksTest
extends JbpmTestCase {
    Wiser wiser = new Wiser();
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/test/task/multiple/process.jpdl.xml").deploy();
        this.identityService.createUser("johndoe", "John", "Doe", "john@doe");
        this.wiser.setPort(2525);
        this.wiser.start();
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        this.identityService.deleteUser("johndoe");
        super.tearDown();
    }

    public void testOltWorkflow() {
        this.executionService.startProcessInstanceByKey("MultipleTasks");
        List taskList = this.taskService.findPersonalTasks("johndoe");
        MultipleTasksTest.assertEquals((int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        MultipleTasksTest.assertEquals((String)"task1", (String)task.getName());
        MultipleTasksTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        this.taskService.completeTask(task.getId());
        taskList = this.taskService.findPersonalTasks("johndoe");
        MultipleTasksTest.assertEquals((int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        MultipleTasksTest.assertEquals((String)"task2", (String)task.getName());
        MultipleTasksTest.assertEquals((String)"johndoe", (String)task.getAssignee());
    }
}

