/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.timer;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class TimerTransitionAsLoopTest
extends JbpmTestCase {
    private static final String TEST_PROCESS_TIMER = "<process name='TimerTransitionAsLoop' xmlns='http://jbpm.org/4.3/jpdl'>  <start name='start1' g='8,77,48,48'>    <transition name='to wait' to='wait for status' g='-24,-18'/>  </start>  <state name='wait for status' g='134,75,112,52'>    <transition name='to get status' to='get status' g='-45,-18'>      <timer duedate='2 minutes'/>    </transition>  </state>  <script g='333,80,92,52' name='get status' expr='#{true}' var='status'>    <transition name='transition 1' g='261,198:-17,-3' to='wait for status'/>  </script></process>";
    private static final String TEST_TIMER_TRANSITION_SELF = "<?xml version='1.0' encoding='UTF-8'?><process name='TimerTransition' xmlns='http://jbpm.org/4.3/jpdl'>  <start g='19,50,48,48'>    <transition to='guardedWait' />  </start>  <state name='guardedWait' g='98,46,127,52'>    <transition name='go on' to='next step' g='-16,-17'/>    <transition name='timeout' to='escalation' g='-43,-16'>      <timer duedate='1 hour' />    </transition>    <transition name='selft' to='guardedWait' />  </state>  <state name='next step' g='283,46,83,53'/>  <state name='escalation' g='118,140,88,52' /></process>";

    public void testTimerTransitionAsLoop() {
        this.deployJpdlXmlString(TEST_PROCESS_TIMER);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerTransitionAsLoop");
        Job job = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).uniqueResult();
        this.managementService.executeJob(job.getId());
    }

    public void testTimerTransitionContinueBeforeTimerFires() {
        this.deployJpdlXmlString(TEST_TIMER_TRANSITION_SELF);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("TimerTransition");
        String executionId = processInstance.findActiveExecutionIn("guardedWait").getId();
        this.executionService.signalExecutionById(executionId, "selft");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        executionId = processInstance.findActiveExecutionIn("guardedWait").getId();
        this.executionService.signalExecutionById(executionId, "go on");
        processInstance = this.executionService.findProcessInstanceById(processInstance.getId());
        TimerTransitionAsLoopTest.assertTrue((boolean)processInstance.isActive("next step"));
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstance.getId()).list();
        TimerTransitionAsLoopTest.assertEquals(new ArrayList(), new ArrayList(jobs));
    }
}

