/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console.graphView;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    private XmlUtil() {
    }

    public static Document parseXmlText(String xml) {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        return XmlUtil.parseXmlInputSource(new InputSource(bais));
    }

    public static Document parseXmlResource(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot load stream null");
        }
        InputSource inputSource = new InputSource(inputStream);
        return XmlUtil.parseXmlInputSource(inputSource);
    }

    public static Document parseXmlInputStream(InputStream inputStream) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't parse xml", e);
        }
        return document;
    }

    public static Document parseXmlInputSource(InputSource inputSource) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputSource);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't parse xml", e);
        }
        return document;
    }

    public static DocumentBuilder getDocumentBuilder() throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    public static Iterator elementIterator(Element element, String tagName) {
        return XmlUtil.elements(element, tagName).iterator();
    }

    public static List elements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        ArrayList<Node> elements = new ArrayList<Node>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getParentNode() != element) continue;
            elements.add(child);
        }
        return elements;
    }

    public static Element element(Element element, String name) {
        Element childElement = null;
        NodeList nodeList = element.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            childElement = (Element)nodeList.item(0);
        }
        return childElement;
    }

    public static Iterator elementIterator(Element element) {
        return XmlUtil.elements(element).iterator();
    }

    public static List elements(Element element) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || element != node.getParentNode()) continue;
            elements.add(node);
        }
        return elements;
    }

    public static Element element(Element element) {
        Element onlyChild = null;
        List elements = XmlUtil.elements(element);
        if (!elements.isEmpty()) {
            onlyChild = (Element)elements.get(0);
        }
        return onlyChild;
    }

    public static String toString(Element element) {
        if (element == null) {
            return "null";
        }
        DOMSource source = new DOMSource(element);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StreamResult result = new StreamResult(printWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't write element '" + element.getTagName() + "' to string", e);
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuilder text = new StringBuilder();
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)child;
            text.append(characterData.getData());
        }
        return text.toString();
    }
}

