/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.cmd;

import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.history.HistoryComment;
import org.jbpm.pvm.internal.cmd.AbstractCommand;
import org.jbpm.pvm.internal.history.model.HistoryCommentImpl;
import org.jbpm.pvm.internal.history.model.HistoryTaskImpl;
import org.jbpm.pvm.internal.session.DbSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddTaskCommentCmd
extends AbstractCommand<HistoryComment> {
    private static final long serialVersionUID = 1L;
    protected Long taskDbid;
    protected String message;

    public AddTaskCommentCmd(String taskId, String message) {
        this.taskDbid = Long.parseLong(taskId);
        this.message = message;
    }

    @Override
    public HistoryComment execute(Environment environment) throws Exception {
        DbSession dbSession = environment.get(DbSession.class);
        HistoryTaskImpl historyTask = dbSession.get(HistoryTaskImpl.class, this.taskDbid);
        if (historyTask == null) {
            throw new JbpmException("task " + this.taskDbid + " doesn't exist");
        }
        HistoryCommentImpl comment = new HistoryCommentImpl(this.message);
        historyTask.addDetail(comment);
        dbSession.save(comment);
        return comment;
    }
}

