/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.el;

import javax.el.ELContext;
import javax.el.ValueExpression;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;

public class UelValueExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    protected ValueExpression valueExpression;

    public UelValueExpression(ValueExpression valueExpression) {
        this.valueExpression = valueExpression;
        if (valueExpression == null) {
            throw new JbpmException("no value expression configured");
        }
    }

    public Object evaluateInScope(ScopeInstanceImpl scopeInstance) {
        ELContext elContext = this.getElContext(scopeInstance);
        return this.valueExpression.getValue(elContext);
    }

    public void setValue(Task task, Object value) {
        this.setValue((ScopeInstanceImpl)((Object)task), value);
    }

    public void setValue(Execution execution, Object value) {
        this.setValue((ScopeInstanceImpl)((Object)execution), value);
    }

    public void setValue(ScopeInstanceImpl scopeInstance, Object value) {
        ELContext elContext = this.getElContext(scopeInstance);
        this.valueExpression.setValue(elContext, value);
    }

    public String getExpressionString() {
        return this.valueExpression.getExpressionString();
    }

    public boolean isLiteralText() {
        return false;
    }
}

