/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.email.impl;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.identity.Group;
import org.jbpm.api.identity.User;
import org.jbpm.pvm.internal.el.Expression;
import org.jbpm.pvm.internal.email.impl.AddressTemplate;
import org.jbpm.pvm.internal.email.impl.AttachmentTemplate;
import org.jbpm.pvm.internal.email.impl.MailTemplate;
import org.jbpm.pvm.internal.email.spi.AddressResolver;
import org.jbpm.pvm.internal.email.spi.MailProducer;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailProducerImpl
implements MailProducer,
Serializable {
    private static final long serialVersionUID = 1L;
    private MailTemplate template;

    public MailTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(MailTemplate template) {
        this.template = template;
    }

    @Override
    public Collection<Message> produce(Execution execution) {
        try {
            Message email = this.instantiateEmail();
            this.fillFrom(execution, email);
            this.fillRecipients(execution, email);
            this.fillSubject(execution, email);
            this.fillContent(execution, email);
            return Collections.singleton(email);
        }
        catch (MessagingException e) {
            throw new JbpmException("failed to produce email message", e);
        }
    }

    protected Message instantiateEmail() {
        return new MimeMessage((Session)null);
    }

    protected void fillFrom(Execution execution, Message email) throws MessagingException {
        String groupList;
        AddressTemplate fromTemplate = this.template.getFrom();
        if (fromTemplate == null) {
            return;
        }
        String addresses = fromTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(addresses);
            email.addFrom((Address[])InternetAddress.parse((String)addresses, (boolean)false));
        }
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        IdentitySession identitySession = environment.get(IdentitySession.class);
        AddressResolver addressResolver = environment.get(AddressResolver.class);
        String userList = fromTemplate.getUsers();
        if (userList != null) {
            String[] userIds = this.tokenizeActors(userList, execution);
            List<User> users = identitySession.findUsersById(userIds);
            email.addFrom(this.resolveAddresses(users, addressResolver));
        }
        if ((groupList = fromTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, execution)) {
                Group group = identitySession.findGroupById(groupId);
                email.addFrom(addressResolver.resolveAddresses(group));
            }
        }
    }

    private String evaluateExpression(String expression) {
        return this.evaluateExpression(expression, String.class);
    }

    private <T> T evaluateExpression(String expression, Class<T> type) {
        Object value = Expression.create(expression, this.template.getLanguage()).evaluate();
        return type.cast(value);
    }

    private String[] tokenizeActors(String recipients, Execution execution) {
        String[] actors = this.evaluateExpression(recipients).split("[,;\\s]+");
        if (actors.length == 0) {
            throw new JbpmException("recipient list is empty: " + recipients);
        }
        return actors;
    }

    private Address[] resolveAddresses(List<User> users, AddressResolver addressResolver) {
        int userCount = users.size();
        Address[] addresses = new Address[userCount];
        for (int i = 0; i < userCount; ++i) {
            addresses[i] = addressResolver.resolveAddress(users.get(i));
        }
        return addresses;
    }

    protected void fillRecipients(Execution execution, Message email) throws MessagingException {
        AddressTemplate bcc;
        AddressTemplate cc;
        AddressTemplate to = this.template.getTo();
        if (to != null) {
            this.fillRecipients(to, execution, email, Message.RecipientType.TO);
        }
        if ((cc = this.template.getCc()) != null) {
            this.fillRecipients(cc, execution, email, Message.RecipientType.CC);
        }
        if ((bcc = this.template.getBcc()) != null) {
            this.fillRecipients(bcc, execution, email, Message.RecipientType.BCC);
        }
    }

    private void fillRecipients(AddressTemplate addressTemplate, Execution execution, Message email, Message.RecipientType recipientType) throws MessagingException {
        String groupList;
        String addresses = addressTemplate.getAddresses();
        if (addresses != null) {
            addresses = this.evaluateExpression(addresses);
            email.addRecipients(recipientType, (Address[])InternetAddress.parse((String)addresses, (boolean)false));
        }
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        IdentitySession identitySession = environment.get(IdentitySession.class);
        AddressResolver addressResolver = environment.get(AddressResolver.class);
        String userList = addressTemplate.getUsers();
        if (userList != null) {
            String[] userIds = this.tokenizeActors(userList, execution);
            List<User> users = identitySession.findUsersById(userIds);
            email.addRecipients(recipientType, this.resolveAddresses(users, addressResolver));
        }
        if ((groupList = addressTemplate.getGroups()) != null) {
            for (String groupId : this.tokenizeActors(groupList, execution)) {
                Group group = identitySession.findGroupById(groupId);
                email.addRecipients(recipientType, addressResolver.resolveAddresses(group));
            }
        }
    }

    protected void fillSubject(Execution execution, Message email) throws MessagingException {
        String subject = this.template.getSubject();
        if (subject != null) {
            subject = this.evaluateExpression(subject);
            email.setSubject(subject);
        }
    }

    protected void fillContent(Execution execution, Message email) throws MessagingException {
        String text = this.template.getText();
        String html = this.template.getHtml();
        List<AttachmentTemplate> attachmentTemplates = this.template.getAttachmentTemplates();
        if (html != null || !attachmentTemplates.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart("related");
            if (text != null) {
                MimeBodyPart textPart = new MimeBodyPart();
                text = this.evaluateExpression(text);
                textPart.setText(text);
                multipart.addBodyPart((BodyPart)textPart);
            }
            if (html != null) {
                MimeBodyPart htmlPart = new MimeBodyPart();
                html = this.evaluateExpression(html);
                htmlPart.setContent((Object)html, "text/html");
                multipart.addBodyPart((BodyPart)htmlPart);
            }
            if (!attachmentTemplates.isEmpty()) {
                this.addAttachments(execution, (Multipart)multipart);
            }
            email.setContent((Multipart)multipart);
        } else if (text != null) {
            text = this.evaluateExpression(text);
            email.setText(text);
        }
    }

    protected void addAttachments(Execution execution, Multipart multipart) throws MessagingException {
        for (AttachmentTemplate attachmentTemplate : this.template.getAttachmentTemplates()) {
            MimeBodyPart attachmentPart = new MimeBodyPart();
            String description = attachmentTemplate.getDescription();
            if (description != null) {
                attachmentPart.setDescription(this.evaluateExpression(description));
            }
            DataHandler dataHandler = this.createDataHandler(attachmentTemplate);
            attachmentPart.setDataHandler(dataHandler);
            String name = attachmentTemplate.getName();
            if (name != null) {
                attachmentPart.setFileName(this.evaluateExpression(name));
            } else {
                DataSource dataSource = dataHandler.getDataSource();
                name = dataSource instanceof URLDataSource ? MailProducerImpl.extractResourceName(((URLDataSource)dataSource).getURL()) : dataSource.getName();
                if (name != null) {
                    attachmentPart.setFileName(name);
                }
            }
            multipart.addBodyPart((BodyPart)attachmentPart);
        }
    }

    private DataHandler createDataHandler(AttachmentTemplate attachmentTemplate) {
        URL targetUrl;
        String expression = attachmentTemplate.getExpression();
        if (expression != null) {
            Object object = this.evaluateExpression(expression, Object.class);
            return new DataHandler(object, attachmentTemplate.getMimeType());
        }
        String file = attachmentTemplate.getFile();
        if (file != null) {
            File targetFile = new File(this.evaluateExpression(file));
            if (!targetFile.isFile()) {
                throw new JbpmException("could not read attachment content, file not found: " + targetFile);
            }
            return new DataHandler((DataSource)new FileDataSource(targetFile));
        }
        String url = attachmentTemplate.getUrl();
        if (url != null) {
            url = this.evaluateExpression(url);
            try {
                targetUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new JbpmException("could not read attachment content, malformed url: " + url, e);
            }
        } else {
            String resource = this.evaluateExpression(attachmentTemplate.getResource());
            targetUrl = Thread.currentThread().getContextClassLoader().getResource(resource);
            if (targetUrl == null) {
                throw new JbpmException("could not read attachment content, resource not found: " + resource);
            }
        }
        return new DataHandler(targetUrl);
    }

    private static String extractResourceName(URL url) {
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int sepIndex = path.lastIndexOf(47);
        return sepIndex != -1 ? path.substring(sepIndex + 1) : null;
    }
}

