/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.identity.cmd;

import java.util.List;
import org.jbpm.api.cmd.Command;
import org.jbpm.api.cmd.Environment;
import org.jbpm.api.identity.Group;
import org.jbpm.pvm.internal.identity.spi.IdentitySession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindGroupsCmd
implements Command<List<Group>> {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String groupType;

    public FindGroupsCmd(String userId) {
        this.userId = userId;
    }

    public FindGroupsCmd(String userId, String groupType) {
        this.userId = userId;
        this.groupType = groupType;
    }

    @Override
    public List<Group> execute(Environment environment) throws Exception {
        IdentitySession identitySession = environment.get(IdentitySession.class);
        if (this.groupType != null) {
            return identitySession.findGroupsByUserAndGroupType(this.userId, this.groupType);
        }
        return identitySession.findGroupsByUser(this.userId);
    }
}

