/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jms;

import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jbpm.internal.log.Log;

public class JmsMessageUtil {
    private static final Log log = Log.getLog(JmsMessageUtil.class.getName());

    public static String dump(Message message) {
        StringBuilder dump = new StringBuilder();
        dump.append("JMS MessageImpl Dump\n").append("MessageImpl type is " + message.getClass().getName() + "\n");
        try {
            if (message instanceof ObjectMessage) {
                dump.append("MessageImpl object type is " + ((ObjectMessage)message).getObject().getClass().getName() + "\n");
            }
            dump.append("Reply to " + JmsMessageUtil.getDestinationName(message.getJMSReplyTo()) + "\n");
            Enumeration e = message.getPropertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                Object property = message.getObjectProperty(propertyName);
                dump.append("Property " + propertyName + " value " + property.toString() + "\n");
            }
        }
        catch (JMSException j) {
            log.error("JMS exception while dumping message", j);
        }
        return dump.toString();
    }

    public static String getDestinationName(Destination d) {
        try {
            if (d instanceof Queue) {
                return ((Queue)d).getQueueName();
            }
            if (d instanceof Topic) {
                return ((Topic)d).getTopicName();
            }
        }
        catch (JMSException j) {
            log.error("JMS exception while getting destination name", j);
        }
        return null;
    }
}

