/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.util.Collection;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.cmd.ExecuteJobCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobParcel
implements Runnable {
    private static final Log log = Log.getLog(JobParcel.class.getName());
    private final CommandService commandService;
    private final Collection<Long> jobDbids;

    public JobParcel(CommandService commandService, Collection<Long> jobDbids) {
        this.commandService = commandService;
        this.jobDbids = jobDbids;
    }

    @Override
    public void run() {
        for (Long jobDbid : this.jobDbids) {
            try {
                this.commandService.execute(new ExecuteJobCmd(jobDbid));
            }
            catch (RuntimeException e) {
                log.error("failed to execute job: " + jobDbid, e);
            }
        }
    }

    public String toString() {
        return JobParcel.class.getSimpleName() + this.jobDbids;
    }
}

