/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.svc;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jbpm.api.HistoryService;
import org.jbpm.api.history.HistoryActivityInstanceQuery;
import org.jbpm.api.history.HistoryDetailQuery;
import org.jbpm.api.history.HistoryProcessInstanceQuery;
import org.jbpm.api.history.HistoryTaskQuery;
import org.jbpm.pvm.internal.cmd.CreateHistoryActivityInstanceQueryCmd;
import org.jbpm.pvm.internal.cmd.CreateHistoryDetailQueryCmd;
import org.jbpm.pvm.internal.cmd.CreateHistoryProcessInstanceQueryCmd;
import org.jbpm.pvm.internal.cmd.CreateHistoryTaskQueryCmd;
import org.jbpm.pvm.internal.cmd.GetHistoryVariableNamesCmd;
import org.jbpm.pvm.internal.cmd.GetHistoryVariablesCmd;
import org.jbpm.pvm.internal.query.AvgDurationPerActivityQueryCmd;
import org.jbpm.pvm.internal.query.ChoiceDistributionQueryCmd;
import org.jbpm.pvm.internal.query.HistoryActivityInstanceQueryImpl;
import org.jbpm.pvm.internal.query.HistoryDetailQueryImpl;
import org.jbpm.pvm.internal.query.HistoryProcessInstanceQueryImpl;
import org.jbpm.pvm.internal.query.HistoryTaskQueryImpl;
import org.jbpm.pvm.internal.svc.AbstractServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryServiceImpl
extends AbstractServiceImpl
implements HistoryService {
    @Override
    public Map<String, Number> avgDurationPerActivity(String processDefinitionId) {
        return this.commandService.execute(new AvgDurationPerActivityQueryCmd(processDefinitionId));
    }

    @Override
    public Map<String, Number> choiceDistribution(String processDefinitionId, String activityName) {
        return this.commandService.execute(new ChoiceDistributionQueryCmd(processDefinitionId, activityName));
    }

    @Override
    public HistoryProcessInstanceQuery createHistoryProcessInstanceQuery() {
        HistoryProcessInstanceQueryImpl query = this.commandService.execute(new CreateHistoryProcessInstanceQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    @Override
    public HistoryActivityInstanceQuery createHistoryActivityInstanceQuery() {
        HistoryActivityInstanceQueryImpl query = this.commandService.execute(new CreateHistoryActivityInstanceQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    @Override
    public HistoryTaskQuery createHistoryTaskQuery() {
        HistoryTaskQueryImpl query = this.commandService.execute(new CreateHistoryTaskQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    @Override
    public HistoryDetailQuery createHistoryDetailQuery() {
        HistoryDetailQueryImpl query = this.commandService.execute(new CreateHistoryDetailQueryCmd());
        query.setCommandService(this.commandService);
        return query;
    }

    @Override
    public Set<String> getVariableNames(String processInstanceId) {
        return this.commandService.execute(new GetHistoryVariableNamesCmd(processInstanceId));
    }

    @Override
    public Object getVariable(String processInstanceId, String variableName) {
        Set<String> variableNames = Collections.singleton(variableName);
        Map variables = (Map)this.commandService.execute(new GetHistoryVariablesCmd(processInstanceId, variableNames));
        return variables.get(variableName);
    }

    @Override
    public Map<String, ?> getVariables(String processInstanceId, Set<String> variableNames) {
        return (Map)this.commandService.execute(new GetHistoryVariablesCmd(processInstanceId, variableNames));
    }
}

