/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.task;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.jbpm.api.Execution;
import org.jbpm.api.JbpmException;
import org.jbpm.api.task.Assignable;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Swimlane;
import org.jbpm.api.task.Task;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.history.HistoryEvent;
import org.jbpm.pvm.internal.history.events.TaskComplete;
import org.jbpm.pvm.internal.history.events.TaskDelete;
import org.jbpm.pvm.internal.history.events.TaskSkip;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.model.ScopeInstanceImpl;
import org.jbpm.pvm.internal.session.DbSession;
import org.jbpm.pvm.internal.task.OpenTask;
import org.jbpm.pvm.internal.task.ParticipationImpl;
import org.jbpm.pvm.internal.task.SwimlaneImpl;
import org.jbpm.pvm.internal.task.TaskDefinitionImpl;
import org.jbpm.pvm.internal.util.EqualsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskImpl
extends ScopeInstanceImpl
implements OpenTask,
Assignable {
    private static final long serialVersionUID = 1L;
    protected boolean isNew;
    protected String name;
    protected String description;
    protected String assignee;
    protected Set<ParticipationImpl> participations = new HashSet<ParticipationImpl>();
    protected String formResourceName;
    protected Date createTime;
    protected Date duedate;
    protected Integer progress;
    protected boolean isSignalling;
    protected int priority = 0;
    protected String taskDefinitionName;
    protected TaskDefinitionImpl taskDefinition;
    protected ExecutionImpl execution;
    protected ExecutionImpl processInstance;
    protected String executionId;
    protected String activityName;
    protected SwimlaneImpl swimlane;
    protected TaskImpl superTask;
    protected Set<TaskImpl> subTasks;
    protected Long executionDbid;
    protected Long superTaskDbid;

    public TaskImpl() {
        this.state = "open";
    }

    @Override
    public ScopeInstanceImpl getParentVariableScope() {
        return this.execution;
    }

    @Override
    public TaskImpl getTask() {
        return this;
    }

    public void take(String userId) {
        if (this.assignee != null) {
            throw new JbpmException("task already taken by " + this.assignee);
        }
        this.setAssignee(userId, true);
    }

    @Override
    public void setAssignee(String userId) {
        this.setAssignee(userId, false);
    }

    public void setAssignee(String assignee, boolean propagateToSwimlane) {
        this.assignee = assignee;
        if (propagateToSwimlane) {
            this.propagateAssigneeToSwimlane();
        }
        if (this.execution != null) {
            this.execution.fire("assign", this.execution.getActivity());
        }
    }

    protected void propagateAssigneeToSwimlane() {
        if (this.swimlane != null) {
            this.swimlane.setAssignee(this.assignee);
        }
    }

    public Set<ParticipationImpl> getParticipations() {
        return this.participations;
    }

    public Set<ParticipationImpl> getAllParticipants() {
        HashSet<ParticipationImpl> allRoles = new HashSet<ParticipationImpl>();
        if (!this.participations.isEmpty()) {
            allRoles = new HashSet<ParticipationImpl>(this.participations);
        }
        if (this.swimlane != null) {
            allRoles.addAll(this.swimlane.getParticipations());
        }
        return allRoles;
    }

    @Override
    public void addCandidateGroup(String groupId) {
        this.addParticipation(null, groupId, "candidate");
    }

    @Override
    public void addCandidateUser(String userId) {
        this.addParticipation(userId, null, "candidate");
    }

    public Participation addParticipation(String userId, String groupId, String type) {
        return this.addParticipant(new ParticipationImpl(userId, groupId, type));
    }

    private Participation addParticipant(ParticipationImpl participation) {
        participation.setTask(this);
        this.participations.add(participation);
        return participation;
    }

    public void removeParticipant(ParticipationImpl participation) {
        if (participation == null) {
            throw new JbpmException("participant is null");
        }
        if (this.participations.remove(participation)) {
            participation.setTask(null);
        }
    }

    public void complete() {
        this.complete("jbpm_no_task_outcome_specified_jbpm");
    }

    public void complete(String outcome) {
        this.historyTaskComplete(outcome);
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class, false);
        if (dbSession != null) {
            dbSession.delete(this);
        }
        if (this.isSignalling()) {
            ExecutionImpl execution = this.getExecution();
            execution.signal(outcome);
        }
        if (this.superTask != null) {
            this.superTask.subTaskComplete(this, outcome);
        }
    }

    protected void subTaskComplete(TaskImpl subTask, String outcome) {
    }

    @Override
    public void delete(String reason) {
        this.historyTaskDelete(reason);
    }

    public void skip(String outcome) {
        if (outcome == null || outcome.equals("")) {
            outcome = "jbpm_no_task_outcome_specified_jbpm";
        }
        this.historyTaskSkip(outcome);
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class, false);
        if (dbSession != null) {
            dbSession.delete(this);
        }
    }

    public boolean isCompleted() {
        return !"open".equals(this.state) && !"suspended".equals(this.state);
    }

    public Set<Task> getSubTasks() {
        return this.subTasks != null ? Collections.unmodifiableSet(this.subTasks) : Collections.emptySet();
    }

    @Override
    public TaskImpl createSubTask() {
        DbSession dbSession = EnvironmentImpl.getFromCurrent(DbSession.class);
        TaskImpl subTask = dbSession.createTask();
        if (this.subTasks == null) {
            this.subTasks = new HashSet<TaskImpl>();
        }
        this.addSubTask(subTask);
        return subTask;
    }

    @Override
    public TaskImpl createSubTask(String name) {
        TaskImpl subtask = this.createSubTask();
        subtask.setName(name);
        return subtask;
    }

    public TaskImpl addSubTask(TaskImpl subtask) {
        if (this.subTasks == null) {
            this.subTasks = new HashSet<TaskImpl>();
        }
        subtask.setSuperTask(this);
        this.subTasks.add(subtask);
        return subtask;
    }

    public void removeSubTask(Task subtask) {
        if (subtask == null) {
            throw new JbpmException("subtask is null");
        }
        if (this.subTasks != null && this.subTasks.remove(subtask)) {
            ((TaskImpl)subtask).setSuperTask(null);
        }
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public String toString() {
        return "Task(" + this.name + ")";
    }

    public String getLifeCycleResource() {
        return "jbpm.task.lifecycle.xml";
    }

    @Override
    public void setProgress(Integer progress) {
        if (progress < 0 || progress > 100) {
            throw new JbpmException("task progress is a percentage (integer) and must be expressed between 0 and 100");
        }
        this.progress = progress;
    }

    public void cancelExecution(String signal) {
        if (this.execution != null) {
            this.execution.end("cancel");
        }
    }

    public void historyTaskDelete(String reason) {
        if (this.execution != null) {
            HistoryEvent.fire(new TaskDelete(this, reason), this.execution);
        }
    }

    public void historyTaskComplete(String outcome) {
        if (this.execution != null) {
            HistoryEvent.fire(new TaskComplete(outcome), this.execution);
        }
    }

    public void historyTaskSkip(String outcome) {
        if (this.execution != null) {
            HistoryEvent.fire(new TaskSkip(outcome), this.execution);
        }
    }

    public void signalExecution(String signalName) {
        if (this.execution != null) {
            this.execution.signal(signalName);
        }
    }

    public TaskDefinitionImpl getTaskDefinition() {
        if (this.taskDefinition == null && this.taskDefinitionName != null && this.execution != null) {
            ProcessDefinitionImpl processDefinition = this.execution.getProcessDefinition();
            this.taskDefinition = processDefinition.getTaskDefinition(this.taskDefinitionName);
        }
        return this.taskDefinition;
    }

    @Override
    public String getId() {
        return Long.toString(this.dbid);
    }

    public void setTaskDefinition(TaskDefinitionImpl taskDefinition) {
        this.taskDefinition = taskDefinition;
        this.taskDefinitionName = taskDefinition.getName();
    }

    public void setExecution(ExecutionImpl execution) {
        this.execution = execution;
        this.executionId = execution.getId();
        this.activityName = execution.getActivityName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date create) {
        this.createTime = create;
    }

    @Override
    public Date getDuedate() {
        return this.duedate;
    }

    @Override
    public void setDuedate(Date duedate) {
        this.duedate = duedate;
    }

    @Override
    public ExecutionImpl getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = (ExecutionImpl)execution;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    public Swimlane getSwimlane() {
        return this.swimlane;
    }

    public void setSwimlane(SwimlaneImpl swimlane) {
        this.swimlane = swimlane;
    }

    public TaskImpl getSuperTask() {
        return this.superTask;
    }

    public void setSuperTask(TaskImpl superTask) {
        this.superTask = superTask;
    }

    @Override
    public Integer getProgress() {
        return this.progress;
    }

    public Long getExecutionDbid() {
        return this.executionDbid;
    }

    public void setExecutionDbid(Long executionDbid) {
        this.executionDbid = executionDbid;
    }

    public Long getSuperTaskDbid() {
        return this.superTaskDbid;
    }

    public void setSuperTaskDbid(Long parentTaskDbid) {
        this.superTaskDbid = parentTaskDbid;
    }

    public void setParticipations(Set<ParticipationImpl> participations) {
        this.participations = participations;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public void setSubTasks(Set<TaskImpl> subTasks) {
        this.subTasks = subTasks;
    }

    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionImpl processInstance) {
        this.processInstance = processInstance;
    }

    @Override
    public boolean isSignalling() {
        return this.isSignalling;
    }

    @Override
    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    @Override
    public String getFormResourceName() {
        return this.formResourceName;
    }

    public void setFormResourceName(String form) {
        this.formResourceName = form;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public void setDbid(long dbid) {
        this.dbid = dbid;
    }
}

