/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.wire.xml;

import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireDefinition;
import org.jbpm.pvm.internal.wire.descriptor.AbstractDescriptor;
import org.jbpm.pvm.internal.wire.xml.BindingParser;
import org.jbpm.pvm.internal.xml.Bindings;
import org.jbpm.pvm.internal.xml.Parse;
import org.jbpm.pvm.internal.xml.Parser;
import org.w3c.dom.Element;

public class WireParser
extends Parser {
    public static final String[] DEFAULT_WIRE_BINDING_RESOURCES = new String[]{"jbpm.wire.bindings.xml", "jbpm.user.wire.bindings.xml"};
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog(WireParser.class.getName());
    public static final String CATEGORY_DESCRIPTOR = "descriptor";
    public static final String CATEGORY_OPERATION = "operation";
    public static final String CATEGORY_INTERCEPTOR = "interceptor";
    private static WireParser instance;
    private static Bindings defaultBindings;

    public WireParser() {
        super(defaultBindings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WireParser getInstance() {
        if (instance != null) return instance;
        Class<WireParser> clazz = WireParser.class;
        synchronized (WireParser.class) {
            if (instance != null) return instance;
            instance = new WireParser();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static WireDefinition parseXmlString(String xmlString) {
        return (WireDefinition)WireParser.getInstance().createParse().setString(xmlString).execute().checkErrors("wire definition xml string").getDocumentObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseDocumentElement(Element documentElement, Parse parse) {
        List<Element> elements = XmlUtil.elements(documentElement);
        WireDefinition wireDefinition = parse.contextStackFind(WireDefinition.class);
        if (wireDefinition == null) {
            wireDefinition = new WireDefinition();
        }
        parse.contextStackPush(wireDefinition);
        try {
            for (Element descriptorElement : elements) {
                Descriptor descriptor = (Descriptor)this.parseElement(descriptorElement, parse, CATEGORY_DESCRIPTOR);
                if (wireDefinition == null || descriptor == null) continue;
                wireDefinition.addDescriptor(descriptor);
            }
        }
        finally {
            parse.contextStackPop();
        }
        return wireDefinition;
    }

    public Object parseElement(Element element, Parse parse, String category) {
        Descriptor descriptor;
        if (element == null) {
            return null;
        }
        Object object = super.parseElement(element, parse, category);
        if (object != null && object instanceof Descriptor && (descriptor = (Descriptor)object) instanceof AbstractDescriptor) {
            AbstractDescriptor abstractDescriptor = (AbstractDescriptor)descriptor;
            if (element.hasAttribute("name")) {
                String name = element.getAttribute("name");
                abstractDescriptor.setName(name);
            }
            if (element.hasAttribute("init")) {
                String initText = element.getAttribute("init");
                if ("eager".equalsIgnoreCase(initText)) {
                    abstractDescriptor.setInit('E');
                } else if ("immediate".equalsIgnoreCase(initText)) {
                    abstractDescriptor.setInit('I');
                } else if ("required".equalsIgnoreCase(initText)) {
                    abstractDescriptor.setInit('R');
                } else {
                    abstractDescriptor.setInit('L');
                }
            }
        }
        return object;
    }

    static {
        defaultBindings = new Bindings();
        BindingParser bindingParser = new BindingParser();
        for (String wireResource : DEFAULT_WIRE_BINDING_RESOURCES) {
            Enumeration<URL> resourceUrls;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                resourceUrls = classLoader.getResources(wireResource);
                if (!resourceUrls.hasMoreElements()) {
                    resourceUrls = WireParser.class.getClassLoader().getResources(wireResource);
                }
            }
            catch (Exception e) {
                throw new JbpmException("couldn't get resource urls for " + wireResource, e);
            }
            if (resourceUrls.hasMoreElements()) {
                while (resourceUrls.hasMoreElements()) {
                    URL resourceUrl = resourceUrls.nextElement();
                    log.trace("loading wire bindings from resource: " + resourceUrl);
                    bindingParser.createParse().setUrl(resourceUrl).contextStackPush(defaultBindings).execute().checkErrors(resourceUrl.toString());
                }
                continue;
            }
            log.trace("skipping unavailable wire bindings resource " + wireResource);
        }
    }
}

