package com.seewo.open.sdk;

import com.seewo.open.sdk.constant.SeewoErrorCode;

/**
 * @author Jiaze
 * @date 2018/10/12 下午2:54
 * @since 0.0.1
 */
public class SeewoApiException extends RuntimeException {

    private final int code;

    private final String message;

    private final String requestId;

    public SeewoApiException(int code, String message, String requestId) {
        super(code + " " + message);
        this.code = code;
        this.message = message;
        this.requestId = requestId;
    }

    public SeewoApiException(Exception e) {
        super(e);
        requestId = null;
        code = 400;
        message = "SDK ERROR, 烦请联系希沃开放平台管理员上报BUG";
    }

    public SeewoApiException(SeewoErrorCode errorCode, Exception e) {
        super(e);
        requestId = null;
        code = errorCode.getErrorCode();
        message = errorCode.getErrorMessage();
    }

    public int getCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
