package com.seewo.open.sdk;


import java.lang.reflect.InvocationTargetException;

/**
 * @author Jiaze
 * @date 2017/10/9 15:18
 * @since 0.0.1
 */
public interface SeewoClient {

    /**
     * 调用API
     * @param request API请求对象
     * @param <R> API请求对象对应的业务返回值
     * @param <P> API请求对象对应的业务参数
     * @return R
     */
    <R extends OpenApiResult,P extends OpenApiParam> R invoke(OpenApiRequest<P,R> request);

    /**
     * 执行http请求
     * @param request http请求对象
     * @return http返回值
     */
    HttpResponse execute(HttpRequest request);

    /**
     * 替换Http客户端
     * @param httpClient 客户端
     */
    void setHttpClient(HttpClient httpClient);

}
