package com.seewo.open.sdk.auth;


import com.seewo.open.sdk.Constants;
import com.seewo.open.sdk.util.SeewoStringUtils;

/**
 * @author Jiaze
 * @date 2017/10/10 10:47
 * @since 0.0.1
 */
public class Account {
    private String appId;
    private String appSecret;
    private String signType = Constants.SIGN_METHOD_HMAC;

    public Account(String appId, String appSecret) {
        if (SeewoStringUtils.isEmptyEvenWhiteSpace(appId) || SeewoStringUtils.isEmptyEvenWhiteSpace(appSecret)) {
            throw new IllegalArgumentException("appId or appSecret is empty");
        }
        this.appId = appId;
        this.appSecret = appSecret;
    }

    public Account(String appId, String appSecret, String signType) {
        if (SeewoStringUtils.isEmptyEvenWhiteSpace(appId) || SeewoStringUtils.isEmptyEvenWhiteSpace(appSecret)) {
            throw new IllegalArgumentException("appId or appSecret is empty");
        }
        this.appId = appId;
        this.appSecret = appSecret;
        this.signType = signType;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }
}
