package com.seewo.open.sdk.constant;

/**
 * @author lbin
 * @date 2024-02-05 14:58
 **/

public enum SeewoErrorCode {

    UNKNOWN_HOST(400, "Failed to resolve host"),
    IO_EXCEPTION(400, "An IO exception occurred"),
    CONNECT_EXCEPTION(400, "Failed to connect to the server"),
    SEEWO_SIGN_ERROR(500, "Seewo签名算法异常, 烦请联系希沃开放平台管理员上报BUG"),
    ;

    private Integer errorCode;
    private String errorMessage;

    public Integer getErrorCode() {
        return errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    SeewoErrorCode(Integer errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }
}
