package com.seewo.open.sdk.util;


import com.seewo.open.sdk.HttpRequest;
import com.seewo.open.sdk.HttpResponse;

import javax.net.ssl.*;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

/**
 * 网络工具类。
 *
 * @author carver.gu
 * @since 1.0, Sep 12, 2009
 */
public abstract class WebUtils {


    private static SSLContext ctx = null;

    private static HostnameVerifier verifier = null;

    private static SSLSocketFactory socketFactory = null;

    public static void setHostnameVerifier(HostnameVerifier verifier) {
        WebUtils.verifier = verifier;
    }

    private static class DefaultTrustManager implements X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain,
                                       String authType) throws CertificateException {

        }

        public void checkServerTrusted(X509Certificate[] chain,
                                       String authType) throws CertificateException {

        }
    }

    static {

        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()},
                    new SecureRandom());

            ctx.getClientSessionContext().setSessionTimeout(15);
            ctx.getClientSessionContext().setSessionCacheSize(1000);

            socketFactory = ctx.getSocketFactory();
        } catch (Exception e) {
            //nothing to do
        }

        verifier = new HostnameVerifier() {
            public boolean verify(String hostname, SSLSession session) {
                return hostname.contains("seewo");//默认认证不通过，进行证书校验。
            }
        };

    }

    private WebUtils() {
    }


    /**
     * 执行HTTP请求。
     *
     * @return 响应
     */
    public static HttpResponse method(HttpRequest request) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        HttpResponse rsp = new HttpResponse();
        InputStream in = null;
        try {
            conn = getConnection(
                    new URL(request.getServerUrl() + request.getPath() + request.getQueryString()),
                    request.getHttpMethod(),
                    request.getContentType());
            for(Map.Entry<String,String> entry: request.getHeaders().entrySet()) {
                conn.setRequestProperty(entry.getKey(), CodecUtils.urlEncode(entry.getValue()));
            }
            conn.setConnectTimeout(request.getConnectTimeout());
            conn.setReadTimeout(request.getReadTimeout());
            if((request.getBody() != null && request.getBody().length != 0)) {
                out = conn.getOutputStream();
                out.write(request.getBody());
                out.flush();
            }
            rsp.setStatusCode(conn.getResponseCode());
            rsp.setPhrase(conn.getResponseMessage());
            rsp.setContentType(conn.getContentType());
            rsp.setHeaders(getResponseHeaders(conn));
            in = conn.getErrorStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (in != null) {
                //error
                int bufferSize = 1024 * 256;
                byte[] buffer = new byte[bufferSize];
                int count;
                while ((count = in.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, count);
                }
                rsp.setBodyBuffer(byteArrayOutputStream.toByteArray());
            } else if(conn.getResponseCode() == 200) {
                //success
                in = conn.getInputStream();
                int bufferSize = 1024 * 256;
                byte[] buffer = new byte[bufferSize];
                int count;
                while ((count = in.read(buffer)) > 0) {
                    byteArrayOutputStream.write(buffer, 0, count);
                }
                rsp.setBodyBuffer(byteArrayOutputStream.toByteArray());
            }
        } finally {
            close(out);
            close(in);
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static void close(Closeable closeable) throws IOException {
        if (closeable != null)
            closeable.close();
    }

    private static Map<String,String> getResponseHeaders(HttpURLConnection conn) {
        Map<String,String> pairs = new HashMap<String, String>();
        for (Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            //只取第一个值
            List<String> value = entry.getValue();
            if(value != null && !value.isEmpty()) {
                pairs.put(entry.getKey(),value.get(0));
            }
        }
        return pairs;
    }

    private static HttpURLConnection getConnection(URL url, String method,
                                                   String ctype) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection) url.openConnection();
            connHttps.setSSLSocketFactory(socketFactory);
            connHttps.setHostnameVerifier(verifier);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection) url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html,application/json");
        conn.setRequestProperty("User-Agent", "x-sw-client- 2.0.1 - java");
        conn.setRequestProperty("Content-Type", ctype);
        return conn;
    }

}
