package com.seewo.open.sdk;


import java.util.Map;

/**
 * @author Jiaze
 * @date 2018-3-16 19:27
 * @since 0.0.1
 */
public interface HttpRequest {

    /**
     * 获取请求方法
     * @return GET,POST,PUT,...
     */
    String getHttpMethod();

    /**
     * 设置请求参数
     * @param httpMethod GET,POST,PUT
     */
    void setHttpMethod(String httpMethod);

    /**
     * 获取请求地址
     * @return scheme://domain.com/xx/xx/xxx
     */
    String getServerUrl();

    /**
     * 设置请求地址
     * @param serverUrl 完整的请求地址，如 scheme://domain.com/xx/xx/xxx
     */
    void setServerUrl(String serverUrl);

    /**
     * 获取请求地址
     * @return /xx/xx/xxx
     */
    String getPath();

    /**
     * 设置请求地址
     * @param path 完整的请求地址，如 /xx/xx/xxx
     */
    void setPath(String path);

    /**
     * 设置request body
     * @param body request body 的buffer
     */
    void setBody(byte[] body);

    /**
     * 获取 request body 报文
     * @return buffer
     */
    byte[] getBody();

    /**
     * 获取request body 的 Mime 类型
     * @return eg. application/json
     */
    String getContentType();

    /**
     * 设置request body 的 Mime 类型
     * @param contentType eg. text/html
     */
    void setContentType(String contentType);

    /**
     * 获取请求头部列表
     * @return 如果没有头部的时候返回null，因为有可能一个key 有多个值，所以不可以用map
     */
    Map<String,String> getHeaders();

    /**
     * 获取头部参数 ，如requestUrl= /users/{id} 此处应有 id=xxx 的键值对
     * @return 所有头部参数，不支持多个值
     */
    Map<String, String> getPathVariables();

    /**
     * 添加 request header
     * @param key key
     * @param value value
     */
    void addHeader(String key, String value);

    /**
     * 添加路径参数
     * @param key key
     * @param value value
     */
    void addPathVariable(String key, String value);

    /**
     * 添加url查询参数
     * @param key key
     * @param value value
     */
    void addQuery(String key, String value);

    /**
     * 获取全部url查询参数
     * @return key1=value1&key2=value2
     */
    String getQueryString();

    /**
     * 获取全部查询参数
     * @return
     */
    Map<String,String> getQueries();

    int getReadTimeout();

    void setReadTimeout(int timeout);

    int getConnectTimeout();

    void setConnectTimeout(int timeout);

}
