package com.seewo.open.sdk;


import com.seewo.open.sdk.util.CodecUtils;

import java.util.Map;

/**
 * @author Jiaze
 * @date 2018-3-16 19:30
 * @since 0.0.1
 */
public class HttpResponse {

    private int statusCode;

    private String phrase;

    private Map<String,String> headers;

    private byte[] bodyBuffer;

    private String contentType;

    public int getStatusCode() {
        return statusCode;
    }

    public String getPhrase() {
        return phrase;
    }

    public Map<String,String> getHeaders() {
        return headers;
    }

    public byte[] getBodyBuffer() {
        return bodyBuffer;
    }

    public String getContentType() {
        return contentType;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public void setHeaders(Map<String,String> headers) {
        this.headers = headers;
    }


    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBodyBuffer(byte[] bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    @Override
    public String toString() {
        return headersStr() + "\r\n"
                + bodyStr();
    }

    private String bodyStr() {
        if(bodyBuffer == null || bodyBuffer.length == 0) {
            return "";
        }
        return CodecUtils.byte2string(bodyBuffer);
    }

    private String headersStr() {
        if(headers == null || headers.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for(Map.Entry<String,String> entry : headers.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" : ").append(entry.getValue()).append("\r\n");
        }
        return stringBuilder.toString();
    }
}
