package com.seewo.open.sdk;

import com.seewo.open.sdk.util.CodecUtils;

import java.util.Map;

/**
 * @author Jiaze
 * @date 2018/10/12 上午8:46
 * @since 0.0.1
 */
public abstract class OpenApiRequest<P extends OpenApiParam, R extends OpenApiResult> implements HttpRequest {

    private String serverUrl;

    private P bizModel;

    private String httpMethod;

    private int connectTimeout = 3000;

    private int readTimeout = 15000;

    private String path;

    private String permissionId;

    public String getContentType() {
        return "application/json;charset=utf-8";
    }

    public void setContentType(String contentType) {
        throw new UnsupportedOperationException();
    }

    public void setBizModel(P bizModel) {
        this.bizModel = bizModel;
    }

    public P getBizModel() {
        if(bizModel == null) {
            throw new UnsupportedOperationException("请先调用 setBizModel 设置业务参数对象");
        }
        return bizModel;
    }

    public String getHttpMethod() {
        return httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBody(byte[] body) {
        throw new UnsupportedOperationException();
    }

    public void addHeader(String key, String value) {
        getBizModel().getHeaders().put(key, value);
    }

    public void addPathVariable(String key, String value) {
        getBizModel().getPathVariables().put(key, value);
    }

    public void addQuery(String key, String value) {
        getBizModel().getQueries().put(key, value);
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public byte[] getBody() {
        P p = getBizModel();
        if (p.getBody() == null || p.getBody().equals(OpenApiParam.EMPTY_BODY)) {
            return new byte[0];
        } else {
            return CodecUtils.string2byte(p.getBody());
        }
    }

    public String getQueryString() {
        Map<String, String> queries = getQueries();
        if (queries == null || queries.isEmpty()) return "";
        StringBuilder sb = new StringBuilder("?");
        for (Map.Entry<String, String> entry : queries.entrySet()) {
            sb.append(entry.getKey()).append("=").append(CodecUtils.urlEncode(entry.getValue())).append("&");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public Map<String, String> getQueries() {
        return getBizModel().getQueries();
    }

    public Map<String, String> getHeaders() {
        return getBizModel().getHeaders();
    }

    public Map<String, String> getPathVariables() {
        return getBizModel().getPathVariables();
    }

    public String getPermissionId() {
        return permissionId;
    }

    public void setPermissionId(String permissionId) {
        this.permissionId = permissionId;
    }

    public abstract Class<R> getResponseClass();

    public abstract Class<P> getDomainClass();

    @Override
    public String toString() {
        return "OpenApiRequest{" +
                "serverUrl='" + serverUrl + '\'' +
                ", bizModel=" + bizModel +
                ", httpMethod='" + httpMethod + '\'' +
                ", connectTimeout=" + connectTimeout +
                ", readTimeout=" + readTimeout +
                ", path='" + path + '\'' +
                ", permissionId='" + permissionId + '\'' +
                '}';
    }

}
