package com.seewo.open.sdk;


import com.seewo.open.sdk.serialization.FastjsonSerialization;
import com.seewo.open.sdk.serialization.Serialization;

import java.lang.annotation.*;

/**
 * @author Jiaze
 * @date 2018-3-16 9:43
 * @since 0.0.1
 */
public class ParameterPosition {

    @Retention(RetentionPolicy.RUNTIME)
    @Target({ElementType.TYPE,ElementType.FIELD})
    @Documented
    public @interface ResponseBody {
        Class<? extends Serialization> deserializer()  default FastjsonSerialization.class;
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target({ElementType.FIELD})
    @Documented
    public @interface ResponseArray {
        Class<? extends Serialization> deserializer() default FastjsonSerialization.class;
        Class<?> element();
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target({ElementType.FIELD})
    @Documented
    public @interface RequestBody {
        Class<? extends Serialization> serializer()  default FastjsonSerialization.class;
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @Documented
    public @interface RequestArray {
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @Documented
    public @interface Header {
        String value();
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @Documented
    public @interface PathVariable {
        String value();
    }


    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.FIELD)
    @Documented
    public @interface Query {
        String value();
    }


}
