package com.seewo.open.sdk.serialization;

import java.util.List;

/**
 * @author Jiaze
 * @date 2018-3-16 14:43
 * @since 0.0.1
 */
public interface Serialization {
    /**
     * 序列化
     *
     * @param object 待序列化对象
     * @return 数组
     */
    byte[] serialize(Object object);

    /**
     * 反序列化
     * @param bytes result-body buffer
     * @param clz 序列化后的类
     * @param <T> 序列化后的类型
     * @return 序列化后的类型对象
     */
    <T> T deserialize(byte[] bytes, Class<T> clz);

    /**
     * 反序列化
     * @param bytes result-body buffer
     * @param clz 序列化后的类
     * @param <T> 序列化后的类型
     * @return 序列化后的类型对象
     */
    <T> List<T> deserializeArray(byte[] bytes, Class<T> clz);

}
