/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.util.CodecUtils;
import java.util.Map;

public class HttpResponse {
    private int statusCode;
    private String phrase;
    private Map<String, String> headers;
    private byte[] bodyBuffer;
    private String contentType;

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public byte[] getBodyBuffer() {
        return this.bodyBuffer;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setPhrase(String phrase) {
        this.phrase = phrase;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBodyBuffer(byte[] bodyBuffer) {
        this.bodyBuffer = bodyBuffer;
    }

    public String toString() {
        return this.headersStr() + "\r\n" + this.bodyStr();
    }

    private String bodyStr() {
        if (this.bodyBuffer == null || this.bodyBuffer.length == 0) {
            return "";
        }
        return CodecUtils.byte2string(this.bodyBuffer);
    }

    private String headersStr() {
        if (this.headers == null || this.headers.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            stringBuilder.append(entry.getKey()).append(" : ").append(entry.getValue()).append("\r\n");
        }
        return stringBuilder.toString();
    }
}

