/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk;

import com.seewo.open.sdk.constant.SeewoErrorCode;

public class SeewoApiException
extends RuntimeException {
    private final int code;
    private final String message;
    private final String requestId;

    public SeewoApiException(int code, String message, String requestId) {
        super(code + " " + message);
        this.code = code;
        this.message = message;
        this.requestId = requestId;
    }

    public SeewoApiException(Exception e) {
        super(e);
        this.requestId = null;
        this.code = 400;
        this.message = "SDK ERROR, \u70e6\u8bf7\u8054\u7cfb\u5e0c\u6c83\u5f00\u653e\u5e73\u53f0\u7ba1\u7406\u5458\u4e0a\u62a5BUG";
    }

    public SeewoApiException(SeewoErrorCode errorCode, Exception e) {
        super(e);
        this.requestId = null;
        this.code = errorCode.getErrorCode();
        this.message = errorCode.getErrorMessage();
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

