/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.fastjson.util;

import com.seewo.open.sdk.fastjson.JSON;
import com.seewo.open.sdk.fastjson.JSONException;
import com.seewo.open.sdk.fastjson.JSONObject;
import com.seewo.open.sdk.fastjson.PropertyNamingStrategy;
import com.seewo.open.sdk.fastjson.annotation.JSONField;
import com.seewo.open.sdk.fastjson.annotation.JSONType;
import com.seewo.open.sdk.fastjson.parser.Feature;
import com.seewo.open.sdk.fastjson.parser.JSONScanner;
import com.seewo.open.sdk.fastjson.parser.ParserConfig;
import com.seewo.open.sdk.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.seewo.open.sdk.fastjson.parser.deserializer.ObjectDeserializer;
import com.seewo.open.sdk.fastjson.serializer.CalendarCodec;
import com.seewo.open.sdk.fastjson.serializer.SerializeBeanInfo;
import com.seewo.open.sdk.fastjson.serializer.SerializerFeature;
import com.seewo.open.sdk.fastjson.util.FieldInfo;
import com.seewo.open.sdk.fastjson.util.IOUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class TypeUtils {
    public static boolean compatibleWithJavaBean = false;
    public static boolean compatibleWithFieldName = false;
    private static boolean setAccessibleEnable = true;
    private static boolean oracleTimestampMethodInited = false;
    private static Method oracleTimestampMethod;
    private static boolean oracleDateMethodInited;
    private static Method oracleDateMethod;
    private static boolean optionalClassInited;
    private static Class<?> optionalClass;
    private static boolean transientClassInited;
    private static Class<? extends Annotation> transientClass;
    private static ConcurrentMap<String, Class<?>> mappings;
    private static Class<?> pathClass;
    private static boolean pathClass_error;

    public static String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to char, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to char, value : " + value);
    }

    public static Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        long longValue = -1L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
            return new Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            JSONScanner dateLexer = new JSONScanner(strVal);
            try {
                if (dateLexer.scanISO8601DateIfMatch(false)) {
                    Calendar calendar = dateLexer.getCalendar();
                    Date date = calendar.getTime();
                    return date;
                }
            }
            finally {
                dateLexer.close();
            }
            if (strVal.startsWith("/Date(") && strVal.endsWith(")/")) {
                String dotnetDateStr;
                strVal = dotnetDateStr = strVal.substring(6, strVal.length() - 2);
            }
            if (strVal.indexOf(45) != -1) {
                String format = strVal.length() == JSON.DEFFAULT_DATE_FORMAT.length() ? JSON.DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
                SimpleDateFormat dateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                dateFormat.setTimeZone(JSON.defaultTimeZone);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    throw new JSONException("can not cast to Date, value : " + strVal);
                }
            }
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            Object result;
            Class<?> clazz = value.getClass();
            if ("oracle.sql.TIMESTAMP".equals(clazz.getName())) {
                if (oracleTimestampMethod == null && !oracleTimestampMethodInited) {
                    try {
                        oracleTimestampMethod = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException dateLexer) {
                    }
                    finally {
                        oracleTimestampMethodInited = true;
                    }
                }
                try {
                    result = oracleTimestampMethod.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("can not cast oracle.sql.TIMESTAMP to Date", e);
                }
                return (Date)result;
            }
            if ("oracle.sql.DATE".equals(clazz.getName())) {
                if (oracleDateMethod == null && !oracleDateMethodInited) {
                    try {
                        oracleDateMethod = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException result2) {
                    }
                    finally {
                        oracleDateMethodInited = true;
                    }
                }
                try {
                    result = oracleDateMethod.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("can not cast oracle.sql.DATE to Date", e);
                }
                return (Date)result;
            }
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static java.sql.Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.sql.Date) {
            return (java.sql.Date)value;
        }
        if (value instanceof Date) {
            return new java.sql.Date(((Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new java.sql.Date(((Calendar)value).getTimeInMillis());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (TypeUtils.isNumber(strVal)) {
                longValue = Long.parseLong(strVal);
            } else {
                JSONScanner scanner = new JSONScanner(strVal);
                if (scanner.scanISO8601DateIfMatch(false)) {
                    longValue = scanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : " + strVal);
                }
            }
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new java.sql.Date(longValue);
    }

    public static Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (TypeUtils.isNumber(strVal)) {
                longValue = Long.parseLong(strVal);
            } else {
                JSONScanner scanner = new JSONScanner(strVal);
                if (scanner.scanISO8601DateIfMatch(false)) {
                    longValue = scanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : " + strVal);
                }
            }
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Timestamp, value : " + value);
        }
        return new Timestamp(longValue);
    }

    public static boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!(ch == '+' || ch == '-' ? i != 0 : ch < '0' || ch > '9')) continue;
            return false;
        }
        return true;
    }

    public static Long castToLong(Object value) {
        Map map;
        block9: {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                    return null;
                }
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                try {
                    return Long.parseLong(strVal);
                }
                catch (NumberFormatException numberFormatException) {
                    JSONScanner dateParser = new JSONScanner(strVal);
                    Calendar calendar = null;
                    if (dateParser.scanISO8601DateIfMatch(false)) {
                        calendar = dateParser.getCalendar();
                    }
                    dateParser.close();
                    if (calendar == null) break block9;
                    return calendar.getTimeInMillis();
                }
            }
        }
        if (value instanceof Map && (map = (Map)value).size() == 2 && map.containsKey("andIncrement") && map.containsKey("andDecrement")) {
            Iterator iter = map.values().iterator();
            iter.next();
            Object value2 = iter.next();
            return TypeUtils.castToLong(value2);
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static Integer castToInt(Object value) {
        Map map;
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Integer.parseInt(strVal);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Map && (map = (Map)value).size() == 2 && map.containsKey("andIncrement") && map.containsKey("andDecrement")) {
            Iterator iter = map.values().iterator();
            iter.next();
            Object value2 = iter.next();
            return TypeUtils.castToInt(value2);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return IOUtils.decodeBase64((String)value);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(strVal) || "T".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("F".equalsIgnoreCase(strVal) || "N".equals(strVal)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to boolean, value : " + value);
    }

    public static <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.getGlobalInstance());
    }

    public static <T> T cast(Object obj, Class<T> clazz, ParserConfig config) {
        if (obj == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            Map map = (Map)obj;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, config);
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = TypeUtils.cast(item, clazz.getComponentType(), config);
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz == java.sql.Date.class) {
            return (T)TypeUtils.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, config);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            Date date = TypeUtils.castToDate(obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("can not cast to : " + clazz.getName(), e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (clazz.getName().equals("javax.xml.datatype.XMLGregorianCalendar")) {
            Date date = TypeUtils.castToDate(obj);
            Calendar calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            calendar.setTime(date);
            return (T)CalendarCodec.instance.createXMLGregorianCalendar(calendar);
        }
        if (obj instanceof String) {
            String strVal = (String)obj;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(strVal);
            }
            if (clazz == Locale.class) {
                return (T)TypeUtils.toLocale(strVal);
            }
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static Locale toLocale(String strVal) {
        String[] items = strVal.split("_");
        if (items.length == 1) {
            return new Locale(items[0]);
        }
        if (items.length == 2) {
            return new Locale(items[0], items[1]);
        }
        return new Locale(items[0], items[1], items[2]);
    }

    public static <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            T[] values;
            int ordinal;
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() == 0) {
                    return null;
                }
                return Enum.valueOf(clazz, name);
            }
            if (obj instanceof Number && (ordinal = ((Number)obj).intValue()) < (values = clazz.getEnumConstants()).length) {
                return values[ordinal];
            }
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal) || "NULL".equals(strVal))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    collection.add(TypeUtils.cast(item, itemType, mapping));
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                Class<?> loadClazz;
                String className = (String)iClassObject;
                if (config == null) {
                    config = ParserConfig.global;
                }
                if ((loadClazz = config.checkAutoType(className, null)) == null) {
                    throw new ClassNotFoundException(className + " not found");
                }
                if (!loadClazz.equals(clazz)) {
                    return (T)TypeUtils.castToJavaBean(map, loadClazz, config);
                }
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            if (clazz == Locale.class) {
                Object arg0 = map.get("language");
                Object arg1 = map.get("country");
                if (arg0 instanceof String) {
                    String language = (String)arg0;
                    if (arg1 instanceof String) {
                        String country = (String)arg1;
                        return (T)new Locale(language, country);
                    }
                    if (arg1 == null) {
                        return (T)new Locale(language);
                    }
                }
            }
            if (config == null) {
                config = ParserConfig.getGlobalInstance();
            }
            JavaBeanDeserializer javaBeanDeser = null;
            ObjectDeserializer deserizer = config.getDeserializer(clazz);
            if (deserizer instanceof JavaBeanDeserializer) {
                javaBeanDeser = (JavaBeanDeserializer)deserizer;
            }
            if (javaBeanDeser == null) {
                throw new JSONException("can not get javaBeanDeserializer. " + clazz.getName());
            }
            return (T)javaBeanDeser.createInstance(map, config);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    private static void addBaseClassMappings() {
        Class[] classes;
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put("[B", byte[].class);
        mappings.put("[S", short[].class);
        mappings.put("[I", int[].class);
        mappings.put("[J", long[].class);
        mappings.put("[F", float[].class);
        mappings.put("[D", double[].class);
        mappings.put("[C", char[].class);
        mappings.put("[Z", boolean[].class);
        for (Class clazz : classes = new Class[]{Object.class, Cloneable.class, TypeUtils.loadClass("java.lang.AutoCloseable"), Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, HashMap.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, LinkedHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, TimeUnit.class, ConcurrentHashMap.class, TypeUtils.loadClass("java.util.concurrent.ConcurrentSkipListMap"), TypeUtils.loadClass("java.util.concurrent.ConcurrentSkipListSet"), AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Time.class, java.sql.Date.class, Timestamp.class, SimpleDateFormat.class, JSONObject.class, TypeUtils.loadClass("java.awt.Rectangle"), TypeUtils.loadClass("java.awt.Point"), TypeUtils.loadClass("java.awt.Font"), TypeUtils.loadClass("java.awt.Color"), TypeUtils.loadClass("org.springframework.remoting.support.RemoteInvocation"), TypeUtils.loadClass("org.springframework.remoting.support.RemoteInvocationResult")}) {
            if (clazz == null) continue;
            mappings.put(clazz.getName(), clazz);
        }
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static Class<?> loadClass(String className) {
        return TypeUtils.loadClass(className, null);
    }

    public static boolean isPath(Class<?> clazz) {
        if (pathClass == null && !pathClass_error) {
            try {
                pathClass = Class.forName("java.nio.file.Path");
            }
            catch (Throwable ex) {
                pathClass_error = true;
            }
        }
        if (pathClass != null) {
            return pathClass.isAssignableFrom(clazz);
        }
        return false;
    }

    public static Class<?> getClassFromMapping(String className) {
        return (Class)mappings.get(className);
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        if (className == null || className.length() == 0) {
            return null;
        }
        Class<?> clazz = (Class<?>)mappings.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (className.charAt(0) == '[') {
            Class<?> componentType = TypeUtils.loadClass(className.substring(1), classLoader);
            return Array.newInstance(componentType, 0).getClass();
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            String newClassName = className.substring(1, className.length() - 1);
            return TypeUtils.loadClass(newClassName, classLoader);
        }
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                mappings.put(className, clazz);
                return clazz;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && contextClassLoader != classLoader) {
                clazz = contextClassLoader.loadClass(className);
                mappings.put(className, clazz);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = Class.forName(className);
            mappings.put(className, clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            return clazz;
        }
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> beanType, Map<String, String> aliasMap, PropertyNamingStrategy propertyNamingStrategy) {
        return TypeUtils.buildBeanInfo(beanType, aliasMap, propertyNamingStrategy, false);
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> beanType, Map<String, String> aliasMap, PropertyNamingStrategy propertyNamingStrategy, boolean fieldBased) {
        List<FieldInfo> sortedFieldList;
        int features;
        JSONType jsonType = beanType.getAnnotation(JSONType.class);
        HashMap<String, Field> fieldCacheMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(beanType, fieldCacheMap);
        List<FieldInfo> fieldInfoList = fieldBased ? TypeUtils.computeGettersWithFieldBase(beanType, aliasMap, false, propertyNamingStrategy) : TypeUtils.computeGetters(beanType, jsonType, aliasMap, fieldCacheMap, false, propertyNamingStrategy);
        Object[] fields = new FieldInfo[fieldInfoList.size()];
        fieldInfoList.toArray(fields);
        String[] orders = null;
        String typeName = null;
        if (jsonType != null) {
            orders = jsonType.orders();
            typeName = jsonType.typeName();
            if (typeName.length() == 0) {
                typeName = null;
            }
            features = SerializerFeature.of(jsonType.serialzeFeatures());
        } else {
            features = 0;
        }
        if (orders != null && orders.length != 0) {
            sortedFieldList = fieldBased ? TypeUtils.computeGettersWithFieldBase(beanType, aliasMap, true, propertyNamingStrategy) : TypeUtils.computeGetters(beanType, jsonType, aliasMap, fieldCacheMap, true, propertyNamingStrategy);
        } else {
            sortedFieldList = new ArrayList<FieldInfo>(fieldInfoList);
            Collections.sort(sortedFieldList);
        }
        Object[] sortedFields = new FieldInfo[sortedFieldList.size()];
        sortedFieldList.toArray(sortedFields);
        if (Arrays.equals(sortedFields, fields)) {
            sortedFields = fields;
        }
        return new SerializeBeanInfo(beanType, jsonType, typeName, features, (FieldInfo[])fields, (FieldInfo[])sortedFields);
    }

    public static List<FieldInfo> computeGettersWithFieldBase(Class<?> clazz, Map<String, String> aliasMap, boolean sorted, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields = currentClass.getDeclaredFields();
            TypeUtils.computeFields(currentClass, aliasMap, propertyNamingStrategy, fieldInfoMap, fields);
        }
        return TypeUtils.getFieldInfos(clazz, sorted, fieldInfoMap);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap) {
        return TypeUtils.computeGetters(clazz, aliasMap, true);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> aliasMap, boolean sorted) {
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        HashMap<String, Field> fieldCacheMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, fieldCacheMap);
        return TypeUtils.computeGetters(clazz, jsonType, aliasMap, fieldCacheMap, sorted, PropertyNamingStrategy.CamelCase);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, JSONType jsonType, Map<String, String> aliasMap, Map<String, Field> fieldCacheMap, boolean sorted, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        for (Method method : clazz.getMethods()) {
            String propertyName;
            String methodName = method.getName();
            int ordinal = 0;
            int serialzeFeatures = 0;
            int parserFeatures = 0;
            String label = null;
            if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || method.getReturnType() == ClassLoader.class || method.getName().equals("getMetaClass") && method.getReturnType().getName().equals("groovy.lang.MetaClass")) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation == null) {
                annotation = TypeUtils.getSuperMethodAnnotation(clazz, method);
            }
            if (annotation != null) {
                if (!annotation.serialize()) continue;
                ordinal = annotation.ordinal();
                serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                parserFeatures = Feature.of(annotation.parseFeatures());
                if (annotation.name().length() != 0) {
                    String propertyName2 = annotation.name();
                    if (aliasMap != null && (propertyName2 = aliasMap.get(propertyName2)) == null) continue;
                    FieldInfo fieldInfo = new FieldInfo(propertyName2, method, null, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, null, label);
                    fieldInfoMap.put(propertyName2, fieldInfo);
                    continue;
                }
                if (annotation.label().length() != 0) {
                    label = annotation.label();
                }
            }
            if (methodName.startsWith("get")) {
                char ch;
                if (methodName.length() < 4 || methodName.equals("getClass") || methodName.equals("getDeclaringClass") && clazz.isEnum()) continue;
                char c3 = methodName.charAt(3);
                if (Character.isUpperCase(c3) || c3 > '\u0200') {
                    propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                    propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 3);
                } else if (c3 == '_') {
                    propertyName = methodName.substring(4);
                } else if (c3 == 'f') {
                    propertyName = methodName.substring(3);
                } else {
                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                }
                boolean ignore = TypeUtils.isJSONTypeIgnore(clazz, propertyName);
                if (ignore) continue;
                Field field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                if (field == null && propertyName.length() > 1 && (ch = propertyName.charAt(1)) >= 'A' && ch <= 'Z') {
                    String javaBeanCompatiblePropertyName = TypeUtils.decapitalize(methodName.substring(3));
                    field = ParserConfig.getFieldFromCache(javaBeanCompatiblePropertyName, fieldCacheMap);
                }
                JSONField fieldAnnotation = null;
                if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                    if (!fieldAnnotation.serialize()) continue;
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                    if (fieldAnnotation.name().length() != 0) {
                        propertyName = fieldAnnotation.name();
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                    }
                    if (fieldAnnotation.label().length() != 0) {
                        label = fieldAnnotation.label();
                    }
                }
                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                if (propertyNamingStrategy != null) {
                    propertyName = propertyNamingStrategy.translate(propertyName);
                }
                FieldInfo fieldInfo = new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation, label);
                fieldInfoMap.put(propertyName, fieldInfo);
            }
            if (!methodName.startsWith("is") || methodName.length() < 3 || method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) continue;
            char c2 = methodName.charAt(2);
            if (Character.isUpperCase(c2)) {
                propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(2)) : Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
                propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 2);
            } else if (c2 == '_') {
                propertyName = methodName.substring(3);
            } else {
                if (c2 != 'f') continue;
                propertyName = methodName.substring(2);
            }
            Field field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
            if (field == null) {
                field = ParserConfig.getFieldFromCache(methodName, fieldCacheMap);
            }
            JSONField fieldAnnotation = null;
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                if (!fieldAnnotation.serialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
                }
                if (fieldAnnotation.label().length() != 0) {
                    label = fieldAnnotation.label();
                }
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            if (fieldInfoMap.containsKey(propertyName)) continue;
            FieldInfo fieldInfo = new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation, label);
            fieldInfoMap.put(propertyName, fieldInfo);
        }
        Field[] fields = clazz.getFields();
        TypeUtils.computeFields(clazz, aliasMap, propertyNamingStrategy, fieldInfoMap, fields);
        return TypeUtils.getFieldInfos(clazz, sorted, fieldInfoMap);
    }

    private static List<FieldInfo> getFieldInfos(Class<?> clazz, boolean sorted, Map<String, FieldInfo> fieldInfoMap) {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        boolean containsAll = false;
        String[] orders = null;
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null) {
            orders = annotation.orders();
            if (orders != null && orders.length == fieldInfoMap.size()) {
                containsAll = true;
                for (String string : orders) {
                    if (fieldInfoMap.containsKey(string)) continue;
                    containsAll = false;
                    break;
                }
            } else {
                containsAll = false;
            }
        }
        if (containsAll) {
            for (String string : orders) {
                FieldInfo fieldInfo = fieldInfoMap.get(string);
                fieldInfoList.add(fieldInfo);
            }
        } else {
            for (FieldInfo fieldInfo : fieldInfoMap.values()) {
                fieldInfoList.add(fieldInfo);
            }
            if (sorted) {
                Collections.sort(fieldInfoList);
            }
        }
        return fieldInfoList;
    }

    private static void computeFields(Class<?> clazz, Map<String, String> aliasMap, PropertyNamingStrategy propertyNamingStrategy, Map<String, FieldInfo> fieldInfoMap, Field[] fields) {
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            JSONField fieldAnnotation = field.getAnnotation(JSONField.class);
            int ordinal = 0;
            int serialzeFeatures = 0;
            int parserFeatures = 0;
            String propertyName = field.getName();
            String label = null;
            if (fieldAnnotation != null) {
                if (!fieldAnnotation.serialize()) continue;
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                parserFeatures = Feature.of(fieldAnnotation.parseFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
                if (fieldAnnotation.label().length() != 0) {
                    label = fieldAnnotation.label();
                }
            }
            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) continue;
            if (propertyNamingStrategy != null) {
                propertyName = propertyNamingStrategy.translate(propertyName);
            }
            if (fieldInfoMap.containsKey(propertyName)) continue;
            FieldInfo fieldInfo = new FieldInfo(propertyName, null, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, null, fieldAnnotation, label);
            fieldInfoMap.put(propertyName, fieldInfo);
        }
    }

    private static String getPropertyNameByCompatibleFieldName(Map<String, Field> fieldCacheMap, String methodName, String propertyName, int fromIdx) {
        if (compatibleWithFieldName && !fieldCacheMap.containsKey(propertyName)) {
            String tempPropertyName = methodName.substring(fromIdx);
            return fieldCacheMap.containsKey(tempPropertyName) ? tempPropertyName : propertyName;
        }
        return propertyName;
    }

    public static JSONField getSuperMethodAnnotation(Class<?> clazz, Method method) {
        Class<?> superClass;
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            Class<?>[] types = method.getParameterTypes();
            for (Class<?> interfaceClass : interfaces) {
                for (Method interfaceMethod : interfaceClass.getMethods()) {
                    JSONField annotation;
                    Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                    if (interfaceTypes.length != types.length || !interfaceMethod.getName().equals(method.getName())) continue;
                    boolean match = true;
                    for (int i = 0; i < types.length; ++i) {
                        if (interfaceTypes[i].equals(types[i])) continue;
                        match = false;
                        break;
                    }
                    if (!match || (annotation = interfaceMethod.getAnnotation(JSONField.class)) == null) continue;
                    return annotation;
                }
            }
        }
        if ((superClass = clazz.getSuperclass()) == null) {
            return null;
        }
        if (Modifier.isAbstract(superClass.getModifiers())) {
            Class<?>[] types = method.getParameterTypes();
            for (Method interfaceMethod : superClass.getMethods()) {
                JSONField annotation;
                Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                if (interfaceTypes.length != types.length || !interfaceMethod.getName().equals(method.getName())) continue;
                boolean match = true;
                for (int i = 0; i < types.length; ++i) {
                    if (interfaceTypes[i].equals(types[i])) continue;
                    match = false;
                    break;
                }
                if (!match || (annotation = interfaceMethod.getAnnotation(JSONField.class)) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String propertyName) {
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        if (jsonType != null) {
            String[] fields = jsonType.includes();
            if (fields.length > 0) {
                for (int i = 0; i < fields.length; ++i) {
                    if (!propertyName.equals(fields[i])) continue;
                    return false;
                }
                return true;
            }
            fields = jsonType.ignores();
            for (int i = 0; i < fields.length; ++i) {
                if (!propertyName.equals(fields[i])) continue;
                return true;
            }
        }
        return clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null && TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), propertyName);
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            Type superType = ((Class)type).getGenericSuperclass();
            if (superType == Object.class) {
                return false;
            }
            return TypeUtils.isGenericParamType(superType);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        if (!optionalClassInited) {
            try {
                optionalClass = Class.forName("java.util.Optional");
            }
            catch (Exception exception) {
            }
            finally {
                optionalClassInited = true;
            }
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == optionalClass) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            return (Class)boundType;
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String fieldName, Field[] declaredFields) {
        for (Field field : declaredFields) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return TypeUtils.getField(superClass, fieldName, superClass.getDeclaredFields());
        }
        return null;
    }

    public static int getSerializeFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return SerializerFeature.of(annotation.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return Feature.of(annotation.parseFeatures());
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static void setAccessible(AccessibleObject obj) {
        if (!setAccessibleEnable) {
            return;
        }
        if (obj.isAccessible()) {
            return;
        }
        try {
            obj.setAccessible(true);
        }
        catch (AccessControlException error) {
            setAccessibleEnable = false;
        }
    }

    public static Type getCollectionItemType(Type fieldType) {
        Object itemType = null;
        Class clazz = null;
        if (fieldType instanceof ParameterizedType) {
            WildcardType wildcardType;
            Type[] upperBounds;
            Type actualTypeArgument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)actualTypeArgument).getUpperBounds()).length == 1) {
                actualTypeArgument = upperBounds[0];
            }
            itemType = actualTypeArgument;
        } else if (fieldType instanceof Class && !(clazz = (Class)fieldType).getName().startsWith("java.")) {
            Type superClass = clazz.getGenericSuperclass();
            itemType = TypeUtils.getCollectionItemType(superClass);
        }
        if (itemType == null) {
            itemType = Object.class;
        }
        return itemType;
    }

    public static Class<?> getCollectionItemClass(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            Class itemClass;
            WildcardType wildcardType;
            Type[] upperBounds;
            Type actualTypeArgument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)actualTypeArgument).getUpperBounds()).length == 1) {
                actualTypeArgument = upperBounds[0];
            }
            if (actualTypeArgument instanceof Class) {
                itemClass = (Class)actualTypeArgument;
                if (!Modifier.isPublic(itemClass.getModifiers())) {
                    throw new JSONException("can not create ASMParser");
                }
            } else {
                throw new JSONException("can not create ASMParser");
            }
            return itemClass;
        }
        return Object.class;
    }

    public static Collection createCollection(Type type) {
        Collection<Object> list;
        Class<AbstractCollection> rawClass = TypeUtils.getRawClass(type);
        if (rawClass == AbstractCollection.class || rawClass == Collection.class) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            list = EnumSet.noneOf(itemType);
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create instance error, class " + rawClass.getName());
            }
        }
        return list;
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new JSONException("TODO");
    }

    public static boolean isProxy(Class<?> clazz) {
        for (Class<?> item : clazz.getInterfaces()) {
            String interfaceName = item.getName();
            if (interfaceName.equals("net.sf.cglib.proxy.Factory") || interfaceName.equals("org.springframework.cglib.proxy.Factory")) {
                return true;
            }
            if (!interfaceName.equals("javassist.util.proxy.ProxyObject") && !interfaceName.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransient(Method method) {
        if (method == null) {
            return false;
        }
        if (!transientClassInited) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Exception exception) {
            }
            finally {
                transientClassInited = true;
            }
        }
        if (transientClass != null) {
            Annotation annotation = method.getAnnotation(transientClass);
            return annotation != null;
        }
        return false;
    }

    static {
        oracleDateMethodInited = false;
        optionalClassInited = false;
        transientClassInited = false;
        try {
            compatibleWithJavaBean = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithJavaBean"));
            compatibleWithFieldName = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithFieldName"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        mappings = new ConcurrentHashMap(16, 0.75f, 1);
        TypeUtils.addBaseClassMappings();
        pathClass_error = false;
    }
}

