/*
 * Decompiled with CFR 0.152.
 */
package com.seewo.open.sdk.serialization;

import com.seewo.open.sdk.fastjson.JSONArray;
import com.seewo.open.sdk.fastjson.JSONObject;
import com.seewo.open.sdk.serialization.Serialization;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class FastjsonSerialization
implements Serialization {
    private static final String CHARSET = "UTF-8";

    @Override
    public byte[] serialize(Object object) {
        try {
            return JSONObject.toJSONString(object).getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return JSONObject.toJSONString(object).getBytes();
        }
    }

    @Override
    public <T> List<T> deserializeArray(byte[] bytes, Class<T> clz) {
        String jsonString;
        try {
            jsonString = new String(bytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            jsonString = new String(bytes);
        }
        return JSONArray.parseArray(jsonString, clz);
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clz) {
        String jsonString;
        try {
            jsonString = new String(bytes, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            jsonString = new String(bytes);
        }
        return JSONObject.parseObject(jsonString, clz);
    }
}

