/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.integration.console;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.bpm.console.client.model.DeploymentRef;
import org.jboss.bpm.console.client.model.HistoryActivityInstanceRef;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.JobRef;
import org.jboss.bpm.console.client.model.ParticipantRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.client.model.ProcessInstanceRef;
import org.jboss.bpm.console.client.model.TaskRef;
import org.jboss.bpm.console.client.model.TokenReference;
import org.jbpm.api.Deployment;
import org.jbpm.api.Execution;
import org.jbpm.api.ExecutionService;
import org.jbpm.api.HistoryService;
import org.jbpm.api.ProcessDefinition;
import org.jbpm.api.RepositoryService;
import org.jbpm.api.TaskService;
import org.jbpm.api.history.HistoryActivityInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.api.model.Transition;
import org.jbpm.api.task.Participation;
import org.jbpm.api.task.Task;
import org.jbpm.integration.console.ProcessEngineUtil;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.task.TaskImpl;

public class ModelAdaptor {
    public static ProcessDefinitionRef adoptDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionRef def = new ProcessDefinitionRef();
        def.setId(processDefinition.getId());
        def.setName(processDefinition.getName());
        def.setVersion((long)processDefinition.getVersion());
        def.setKey(processDefinition.getKey());
        def.setSuspended(processDefinition.isSuspended());
        def.setDeploymentId(processDefinition.getDeploymentId());
        return def;
    }

    public static ProcessInstanceRef adoptExecution(Execution execution) {
        ProcessInstanceRef ref = new ProcessInstanceRef();
        ref.setId(execution.getId());
        ref.setKey(execution.getKey());
        ref.setDefinitionId(execution.getProcessDefinitionId());
        HistoryService historyService = ProcessEngineUtil.retrieveProcessEngine().getHistoryService();
        Date startDate = historyService.createHistoryProcessInstanceQuery().processInstanceId(execution.getId()).uniqueResult().getStartTime();
        ref.setStartDate(startDate);
        ExecutionImpl processInstance = (ExecutionImpl)execution.getProcessInstance();
        ProcessDefinitionImpl processDefinition = processInstance.getProcessDefinition();
        TokenReference tok = ModelAdaptor.execution2TokenReference(processInstance);
        Collection childExecutions = processInstance.getExecutions();
        if (childExecutions != null) {
            for (Execution child : childExecutions) {
                ExecutionImpl childExecution = (ExecutionImpl)child;
                childExecution.setProcessDefinition(processDefinition);
                TokenReference childTok = ModelAdaptor.execution2TokenReference(childExecution);
                tok.getChildren().add(childTok);
            }
        }
        ref.setRootToken(tok);
        return ref;
    }

    private static TokenReference execution2TokenReference(ExecutionImpl execution) {
        Set currentActivities;
        String executionId = execution.getId();
        TokenReference tok = new TokenReference();
        tok.setName(execution.getName());
        tok.setId(executionId);
        if (execution.isActive() && "state".equals(execution.getActivity().getType())) {
            tok.setCanBeSignaled(true);
        }
        if ((currentActivities = execution.findActiveActivityNames()).size() == 1) {
            tok.setCurrentNodeName((String)currentActivities.iterator().next());
        } else if (currentActivities.size() > 1) {
            StringBuilder strb = new StringBuilder();
            for (String activeActivity : currentActivities) {
                strb.append(activeActivity + ",");
            }
            tok.setCurrentNodeName(strb.deleteCharAt(strb.length() - 1).toString());
        } else {
            tok.setCurrentNodeName(executionId);
        }
        if (execution.getActivity() != null && "state".equals(execution.getActivity().getType())) {
            ArrayList<String> availableSignals = new ArrayList<String>();
            ExecutionImpl openTopLevelExecution = execution;
            List outTransitions = openTopLevelExecution.getActivity().getOutgoingTransitions();
            if (outTransitions != null) {
                for (Transition t : outTransitions) {
                    String transitionName = t.getName() != null ? t.getName() : "default transition";
                    availableSignals.add(transitionName);
                }
            }
            tok.setAvailableSignals(availableSignals);
        }
        return tok;
    }

    public static TaskRef adoptTask(Task jbpmTask) {
        Execution execution;
        TaskRef task = new TaskRef();
        task.setId(((TaskImpl)jbpmTask).getDbid());
        task.setName(jbpmTask.getName());
        task.setDescription(jbpmTask.getDescription());
        task.setAssignee(jbpmTask.getAssignee());
        task.setPriority(jbpmTask.getPriority());
        task.setDueDate(jbpmTask.getDuedate());
        task.setCreateDate(jbpmTask.getCreateTime());
        ExecutionService executionService = ProcessEngineUtil.retrieveProcessEngine().getExecutionService();
        String executionId = jbpmTask.getExecutionId();
        if (executionId != null && (execution = executionService.findExecutionById(executionId)) != null) {
            Execution pi = execution.getProcessInstance();
            task.setProcessInstanceId(pi.getId());
            task.setProcessId(pi.getProcessDefinitionId());
        }
        TaskService taskService = ProcessEngineUtil.retrieveProcessEngine().getTaskService();
        List participations = taskService.getTaskParticipations(jbpmTask.getId());
        for (Participation participation : participations) {
            if (participation.getType().equals("candidate")) {
                ParticipantRef participant;
                if (participation.getGroupId() != null) {
                    participant = new ParticipantRef("candidate", participation.getGroupId());
                    participant.setGroup(true);
                    task.getParticipantGroups().add(participant);
                    continue;
                }
                if (participation.getUserId() != null) {
                    participant = new ParticipantRef("candidate", participation.getUserId());
                    task.getParticipantUsers().add(participant);
                    continue;
                }
                throw new IllegalArgumentException("Participation doesn't have user or group: " + participation);
            }
            throw new IllegalArgumentException("Unknown participation type: " + participation.getType());
        }
        String url = jbpmTask.getFormResourceName() != null ? jbpmTask.getFormResourceName() : "";
        task.setUrl(url);
        return task;
    }

    public static DeploymentRef adoptDeployment(Deployment deployment) {
        DeploymentRef dRef = new DeploymentRef();
        dRef.setId(deployment.getId());
        dRef.setSuspended(deployment.getState().equals("suspended"));
        dRef.setTimestamp(deployment.getTimestamp());
        RepositoryService repositoryService = ProcessEngineUtil.retrieveProcessEngine().getRepositoryService();
        Set resourceNames = repositoryService.getResourceNames(deployment.getId());
        dRef.getResourceNames().addAll(resourceNames);
        String name = deployment.getName();
        if (name.indexOf("/") != -1) {
            name = name.substring(name.lastIndexOf("/") + 1, name.length());
        }
        dRef.setName(name);
        return dRef;
    }

    public static JobRef adoptJob(Job job) {
        JobRef jobRef = new JobRef();
        jobRef.setId(String.valueOf(job.getId()));
        if (job.getDueDate() != null) {
            jobRef.setTimestamp(job.getDueDate().getTime());
        }
        if (job.getException() != null) {
            jobRef.setErrMsg(job.getException());
        }
        return jobRef;
    }

    public static HistoryActivityInstanceRef adoptHistoryActivity(HistoryActivityInstance history) {
        HistoryActivityInstanceRef historyRef = new HistoryActivityInstanceRef();
        historyRef.setActivityName(history.getActivityName());
        historyRef.setDuration(history.getDuration());
        historyRef.setEndTime(history.getEndTime());
        historyRef.setExecutionId(history.getExecutionId());
        historyRef.setStartTime(history.getStartTime());
        return historyRef;
    }

    public static HistoryProcessInstanceRef adoptHistoryProcessInstance(HistoryProcessInstance history) {
        HistoryProcessInstanceRef historyRef = new HistoryProcessInstanceRef();
        historyRef.setProcessDefinitionId(history.getProcessDefinitionId());
        historyRef.setProcessInstanceId(history.getProcessInstanceId());
        historyRef.setEndTime(history.getEndTime());
        historyRef.setEndActivityName(history.getEndActivityName());
        historyRef.setStartTime(history.getStartTime());
        historyRef.setEndActivityName(history.getEndActivityName());
        historyRef.setDuration(history.getDuration().longValue());
        historyRef.setState(history.getState());
        historyRef.setKey(history.getKey());
        return historyRef;
    }
}

