/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.async.fork;

import java.util.Date;
import java.util.List;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.job.Job;
import org.jbpm.test.JbpmTestCase;

public class AsyncForkTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/async/fork/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testAsyncFork() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("AsyncFork");
        String processInstanceId = processInstance.getId();
        List jobs = this.managementService.createJobQuery().processInstanceId(processInstanceId).list();
        AsyncForkTest.assertEquals((int)2, (int)jobs.size());
        Job job = (Job)jobs.get(0);
        this.managementService.executeJob(job.getId());
        job = (Job)jobs.get(1);
        this.managementService.executeJob(job.getId());
        Date endTime = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult().getEndTime();
        AsyncForkTest.assertNotNull((Object)endTime);
    }
}

