/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.bpmn.gateway.exclusive;

import java.util.HashMap;
import org.jbpm.api.NewDeployment;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.history.HistoryProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class ExclusiveGatewayTest
extends JbpmTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        NewDeployment deployment = this.repositoryService.createDeployment();
        deployment.addResourceFromClasspath("org/jbpm/examples/bpmn/gateway/exclusive/exclusive_gateway.bpmn.xml");
        this.registerDeployment(deployment.deploy());
    }

    public void testWithAmountLowerThan100() {
        this.startAndVerifyProcess(44, "endNotEnough");
    }

    public void testWithAmountBetween100And500() {
        this.startAndVerifyProcess(124, "endEnough");
    }

    public void testWithAmountMoreThan500() {
        this.startAndVerifyProcess(1000, "endMoreThanEnough");
    }

    private void startAndVerifyProcess(int amount, String endId) {
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("amount", amount);
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("exclusiveGateway", vars);
        this.assertProcessInstanceEnded(processInstance);
        HistoryProcessInstance historyProcessInstance = this.historyService.createHistoryProcessInstanceQuery().processInstanceId(processInstance.getId()).uniqueResult();
        ExclusiveGatewayTest.assertEquals((String)endId, (String)historyProcessInstance.getEndActivityName());
    }
}

