/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.concurrency.graphbased;

import java.util.HashSet;
import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class ConcurrencyGraphBasedTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/concurrency/graphbased/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testConcurrencyGraphBased() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("ConcurrencyGraphBased");
        String pid = processInstance.getId();
        HashSet<String> expectedActivityNames = new HashSet<String>();
        expectedActivityNames.add("send invoice");
        expectedActivityNames.add("load truck");
        expectedActivityNames.add("print shipping documents");
        ConcurrencyGraphBasedTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("send invoice"));
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("load truck"));
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String sendInvoiceExecutionId = processInstance.findActiveExecutionIn("send invoice").getId();
        processInstance = this.executionService.signalExecutionById(sendInvoiceExecutionId);
        expectedActivityNames.remove("send invoice");
        ConcurrencyGraphBasedTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("load truck"));
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String loadTruckExecutionId = processInstance.findActiveExecutionIn("load truck").getId();
        processInstance = this.executionService.signalExecutionById(loadTruckExecutionId);
        expectedActivityNames.remove("load truck");
        ConcurrencyGraphBasedTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("print shipping documents"));
        String printShippingDocumentsId = processInstance.findActiveExecutionIn("print shipping documents").getId();
        processInstance = this.executionService.signalExecutionById(printShippingDocumentsId);
        expectedActivityNames.remove("print shipping documents");
        expectedActivityNames.add("drive truck to destination");
        ConcurrencyGraphBasedTest.assertEquals(expectedActivityNames, (Object)processInstance.findActiveActivityNames());
        ConcurrencyGraphBasedTest.assertNotNull((Object)processInstance.findActiveExecutionIn("drive truck to destination"));
        String driveTruckExecutionId = processInstance.findActiveExecutionIn("drive truck to destination").getId();
        processInstance = this.executionService.signalExecutionById(driveTruckExecutionId);
        ConcurrencyGraphBasedTest.assertNull((String)("execution " + pid + " should not exist"), (Object)this.executionService.findExecutionById(pid));
    }
}

