/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.end.multiple;

import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class EndMultipleTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/end/multiple/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testEndMultipleOk() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndMultiple");
        String pid = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(pid, "200");
        EndMultipleTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testEndMultipleBadRequest() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndMultiple");
        String executionId = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(executionId, "400");
        EndMultipleTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testEndMultipleInternalServerError() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndMultiple");
        String executionId = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(executionId, "500");
        EndMultipleTest.assertTrue((boolean)processInstance.isEnded());
    }
}

