/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.end.state;

import org.jbpm.api.ProcessInstance;
import org.jbpm.test.JbpmTestCase;

public class EndStateTest
extends JbpmTestCase {
    String deploymentId;

    protected void setUp() throws Exception {
        super.setUp();
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/end/state/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        super.tearDown();
    }

    public void testEndStateCompleted() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndState");
        String pid = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(pid, "200");
        EndStateTest.assertEquals((String)"completed", (String)processInstance.getState());
        EndStateTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testEndStateErrorBadRequest() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndState");
        String pid = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(pid, "400");
        EndStateTest.assertEquals((String)"cancel", (String)processInstance.getState());
        EndStateTest.assertTrue((boolean)processInstance.isEnded());
    }

    public void testEndStateErrorInternalServerError() {
        ProcessInstance processInstance = this.executionService.startProcessInstanceByKey("EndState");
        String executionId = processInstance.getId();
        processInstance = this.executionService.signalExecutionById(executionId, "500");
        EndStateTest.assertEquals((String)"error", (String)processInstance.getState());
        EndStateTest.assertTrue((boolean)processInstance.isEnded());
    }
}

