/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.examples.task.swimlane;

import java.util.List;
import org.jbpm.api.task.Task;
import org.jbpm.test.JbpmTestCase;

public class TaskSwimlaneTest
extends JbpmTestCase {
    String deploymentId;
    String dept;

    protected void setUp() throws Exception {
        super.setUp();
        this.dept = this.identityService.createGroup("sales-dept");
        this.identityService.createUser("johndoe", "John", "Doe");
        this.identityService.createMembership("johndoe", this.dept, "developer");
        this.deploymentId = this.repositoryService.createDeployment().addResourceFromClasspath("org/jbpm/examples/task/swimlane/process.jpdl.xml").deploy();
    }

    protected void tearDown() throws Exception {
        this.repositoryService.deleteDeploymentCascade(this.deploymentId);
        this.identityService.deleteGroup(this.dept);
        this.identityService.deleteUser("johndoe");
        super.tearDown();
    }

    public void testTaskSwimlane() {
        this.executionService.startProcessInstanceByKey("TaskSwimlane");
        List taskList = this.taskService.findGroupTasks("johndoe");
        TaskSwimlaneTest.assertEquals((String)"Expected a single task in johndoe's task list", (int)1, (int)taskList.size());
        Task task = (Task)taskList.get(0);
        String taskId = task.getId();
        TaskSwimlaneTest.assertEquals((String)"enter order data", (String)task.getName());
        TaskSwimlaneTest.assertNull((Object)task.getAssignee());
        TaskSwimlaneTest.assertEquals((int)0, (int)this.taskService.findPersonalTasks("johndoe").size());
        this.taskService.takeTask(taskId, "johndoe");
        TaskSwimlaneTest.assertEquals((int)0, (int)this.taskService.findGroupTasks("johndoe").size());
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskSwimlaneTest.assertEquals((int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskSwimlaneTest.assertEquals((String)"enter order data", (String)task.getName());
        TaskSwimlaneTest.assertEquals((String)"johndoe", (String)task.getAssignee());
        this.taskService.completeTask(taskId);
        taskList = this.taskService.findPersonalTasks("johndoe");
        TaskSwimlaneTest.assertEquals((int)1, (int)taskList.size());
        task = (Task)taskList.get(0);
        TaskSwimlaneTest.assertEquals((String)"calculate quote", (String)task.getName());
        TaskSwimlaneTest.assertEquals((String)"johndoe", (String)task.getAssignee());
    }
}

